/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSProtocol;
import org.italiangrid.voms.request.VOMSProtocolError;
import org.italiangrid.voms.request.VOMSProtocolListener;
import org.italiangrid.voms.request.VOMSResponse;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.impl.AbstractVOMSProtocol;
import org.italiangrid.voms.request.impl.RESTServiceURLBuilder;
import org.italiangrid.voms.request.impl.RESTVOMSResponseParsingStrategy;

public class RESTProtocol
extends AbstractVOMSProtocol
implements VOMSProtocol {
    public RESTProtocol(X509CertChainValidatorExt validator, VOMSProtocolListener listener, int connectTimeout, int readTimeout) {
        super(validator, listener, connectTimeout, readTimeout);
    }

    public VOMSResponse doRequest(VOMSServerInfo endpoint, X509Credential credential, VOMSACRequest request) {
        RESTServiceURLBuilder restQueryBuilder = new RESTServiceURLBuilder();
        URL serviceUrl = restQueryBuilder.build(endpoint.getURL(), request);
        RESTVOMSResponseParsingStrategy responseParsingStrategy = new RESTVOMSResponseParsingStrategy();
        HttpsURLConnection connection = null;
        try {
            connection = (HttpsURLConnection)serviceUrl.openConnection();
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
        }
        catch (IOException e) {
            throw new VOMSProtocolError(e.getMessage(), endpoint, request, credential, e);
        }
        connection.setSSLSocketFactory(this.getSSLSocketFactory(credential));
        this.listener.notifyHTTPRequest(serviceUrl.toExternalForm());
        try {
            connection.connect();
        }
        catch (IOException e) {
            throw new VOMSProtocolError(e.getMessage(), endpoint, request, credential, e);
        }
        InputStream is = null;
        try {
            is = connection.getResponseCode() != 200 ? connection.getErrorStream() : connection.getInputStream();
        }
        catch (IOException e) {
            throw new VOMSError(e.getMessage(), e);
        }
        VOMSResponse response = responseParsingStrategy.parse(is);
        this.listener.notifyReceivedResponse(response);
        connection.disconnect();
        return response;
    }
}

