/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.voms;

import java.security.cert.X509Certificate;
import java.util.List;
import org.italiangrid.utils.voms.SecurityContextImpl;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.VOMSValidators;
import org.italiangrid.voms.ac.VOMSACValidator;

public class VOMSSecurityContext
extends SecurityContextImpl {
    private static ThreadLocal<VOMSSecurityContext> theSecurityContext = new ThreadLocal();
    private VOMSACValidator validator;

    @Override
    public void setClientCertChain(X509Certificate[] certChain) {
        super.setClientCertChain(certChain);
        if (this.validator == null) {
            this.validator = VOMSValidators.newValidator();
        }
    }

    public static VOMSSecurityContext getCurrentContext() {
        return theSecurityContext.get();
    }

    public static void setCurrentContext(VOMSSecurityContext ctxt) {
        theSecurityContext.set(ctxt);
    }

    public static void clearCurrentContext() {
        theSecurityContext.set(null);
    }

    public VOMSACValidator getValidator() {
        return this.validator;
    }

    public void setValidator(VOMSACValidator validator) {
        this.validator = validator;
    }

    public List<VOMSAttribute> getVOMSAttributes() {
        return this.validator.validate(this.getClientCertChain());
    }
}

