/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.https;

import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyShutdownTask
implements Runnable {
    public static final Logger log = LoggerFactory.getLogger(JettyShutdownTask.class);
    private Server httpServer;

    public JettyShutdownTask(Server s) {
        this.httpServer = s;
    }

    @Override
    public void run() {
        if (this.httpServer.isRunning()) {
            try {
                this.httpServer.stop();
                if (this.httpServer.isStopped()) {
                    log.info("Server stopped.");
                    System.exit(0);
                }
            }
            catch (Exception e) {
                log.error("Unable to shutdown HTTP server", e);
                System.exit(1);
            }
        }
    }
}

