/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Signature;
import java.security.SignatureException;
import org.bouncycastle.cms.CMSStreamException;

class SigOutputStream
extends OutputStream {
    private final Signature sig;

    SigOutputStream(Signature signature) {
        this.sig = signature;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.sig.update(byArray, n, n2);
        }
        catch (SignatureException signatureException) {
            throw new CMSStreamException("signature problem: " + signatureException, signatureException);
        }
    }

    @Override
    public void write(int n) throws IOException {
        try {
            this.sig.update((byte)n);
        }
        catch (SignatureException signatureException) {
            throw new CMSStreamException("signature problem: " + signatureException, signatureException);
        }
    }
}

