/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputEncryptor;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    public CMSEnvelopedDataGenerator() {
    }

    public CMSEnvelopedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    private CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, KeyGenerator keyGenerator, Provider provider) throws NoSuchAlgorithmException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        Object object;
        AlgorithmIdentifier algorithmIdentifier;
        Object object22;
        SecretKey secretKey;
        Object object3;
        Provider provider2 = keyGenerator.getProvider();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            object3 = CMSEnvelopedHelper.INSTANCE.createSymmetricCipher(string, provider2);
            secretKey = keyGenerator.generateKey();
            object22 = this.generateParameters(string, secretKey, provider2);
            ((Cipher)object3).init(1, (Key)secretKey, (AlgorithmParameters)object22, this.rand);
            if (object22 == null) {
                object22 = ((Cipher)object3).getParameters();
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(string, (AlgorithmParameters)object22);
            object = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream((OutputStream)object, (Cipher)object3);
            cMSProcessable.write(cipherOutputStream);
            cipherOutputStream.close();
            bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object).toByteArray());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        for (Object object22 : this.oldRecipientInfoGenerators) {
            try {
                aSN1EncodableVector.add(object22.generate(secretKey, this.rand, provider));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        for (Object object22 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add(object22.generate(new GenericKey(secretKey)));
        }
        object3 = cMSProcessable instanceof CMSTypedData ? new EncryptedContentInfo(((CMSTypedData)cMSProcessable).getContentType(), algorithmIdentifier, bERConstructedOctetString) : new EncryptedContentInfo(CMSObjectIdentifiers.data, algorithmIdentifier, bERConstructedOctetString);
        object22 = null;
        if (this.unprotectedAttributeGenerator != null) {
            object = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            object22 = new BERSet(((AttributeTable)object).toASN1EncodableVector());
        }
        object = new ContentInfo(CMSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(aSN1EncodableVector), (EncryptedContentInfo)object3, (ASN1Set)object22));
        return new CMSEnvelopedData((ContentInfo)object);
    }

    private CMSEnvelopedData doGenerate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        Object object;
        Object object22;
        Object object3;
        if (!this.oldRecipientInfoGenerators.isEmpty()) {
            throw new IllegalStateException("can only use addRecipientGenerator() with this method");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object3 = outputEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object3);
            ((OutputStream)object3).close();
        }
        catch (IOException iOException) {
            throw new CMSException("");
        }
        object3 = byteArrayOutputStream.toByteArray();
        AlgorithmIdentifier algorithmIdentifier = outputEncryptor.getAlgorithmIdentifier();
        BERConstructedOctetString bERConstructedOctetString = new BERConstructedOctetString((byte[])object3);
        GenericKey genericKey = outputEncryptor.getKey();
        for (Object object22 : this.recipientInfoGenerators) {
            aSN1EncodableVector.add(object22.generate(genericKey));
        }
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(cMSTypedData.getContentType(), algorithmIdentifier, bERConstructedOctetString);
        object22 = null;
        if (this.unprotectedAttributeGenerator != null) {
            object = this.unprotectedAttributeGenerator.getAttributes(new HashMap());
            object22 = new BERSet(((AttributeTable)object).toASN1EncodableVector());
        }
        object = new ContentInfo(CMSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(aSN1EncodableVector), encryptedContentInfo, (ASN1Set)object22));
        return new CMSEnvelopedData((ContentInfo)object);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string, CMSUtils.getProvider(string2));
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, provider);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string, n, CMSUtils.getProvider(string2));
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, int n, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(n, this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, provider);
    }

    public CMSEnvelopedData generate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputEncryptor);
    }
}

