/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.gridhttps.server.utils;

import java.io.File;
import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XML {
    private DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder;
    private File xmlFile;
    private Document document;
    private Transformer transformer;
    private XPath xpath;

    private XML() throws ParserConfigurationException, TransformerConfigurationException {
        this.domFactory.setNamespaceAware(true);
        this.builder = this.domFactory.newDocumentBuilder();
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    public XML(String filename) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException {
        this(new File(filename));
    }

    public XML(File xmlFile) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException {
        this();
        this.xmlFile = xmlFile;
        this.document = this.builder.parse(xmlFile);
    }

    public Document getDocument() {
        return this.document;
    }

    public File getFile() {
        return this.xmlFile;
    }

    public void addNamespace() {
    }

    public void saveToFile(File outputFile) throws IOException, TransformerException {
        StreamResult result = new StreamResult(outputFile);
        DOMSource source = new DOMSource(this.document);
        this.transformer.transform(source, result);
    }

    public void save() throws IOException, TransformerException {
        this.saveToFile(this.getFile());
    }

    public NodeList getNodes(String expression, NamespaceContext namespaceContext) throws XPathExpressionException {
        this.xpath.setNamespaceContext(namespaceContext);
        return (NodeList)this.xpath.evaluate(expression, this.getDocument(), XPathConstants.NODESET);
    }

    public Node getNode(String expression, NamespaceContext namespaceContext) throws XPathExpressionException {
        this.xpath.setNamespaceContext(namespaceContext);
        return (Node)this.xpath.evaluate(expression, this.getDocument(), XPathConstants.NODE);
    }
}

