/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.gridhttps.server.data;

import it.grid.storm.gridhttps.server.data.MapperServlet;
import it.grid.storm.gridhttps.server.exceptions.InitException;
import java.io.File;
import org.italiangrid.utils.https.SSLOptions;

public class StormGridhttps {
    private String hostname;
    private int httpPort;
    private int httpsPort;
    private boolean enabledHttp;
    private MapperServlet mapperServlet;
    private String webappsDirectory;
    private SSLOptions ssloptions;
    private String logFile;
    private File warFile;
    private File rootDirectory;
    private String webdavContextPath;
    private String filetransferContextPath;
    private boolean computeChecksum;
    private String checksumType;
    private int mapActiveThreadsMin;
    private int mapActiveThreadsMax;
    private int mapQueuedThreadsMax;
    private int davActiveThreadsMax;
    private int davQueuedThreadsMax;

    public StormGridhttps() {
        this.setHttpPort(8085);
        this.setHttpsPort(8443);
        this.setEnabledHttp(false);
        MapperServlet mapperServlet = new MapperServlet();
        this.setMapperServlet(mapperServlet);
        this.setWebappsDirectory("/var/lib/storm");
        SSLOptions sslOptions = new SSLOptions();
        sslOptions.setCertificateFile("/etc/grid-security/gridhttps/hostcert.pem");
        sslOptions.setKeyFile("/etc/grid-security/gridhttps/hostkey.pem");
        sslOptions.setTrustStoreDirectory("/etc/grid-security/certificates");
        sslOptions.setNeedClientAuth(true);
        sslOptions.setWantClientAuth(true);
        this.setSsloptions(sslOptions);
        this.setLogFile("/etc/storm/gridhttps-server/logback.xml");
        this.setWarFile(null);
        this.setFiletransferContextPath("fileTransfer");
        this.setWebdavContextPath("");
        this.setRootDirectory(new File("/"));
        this.setComputeChecksum(true);
        this.setChecksumType("adler32");
        this.setDavActiveThreadsMax(150);
        this.setDavQueuedThreadsMax(300);
        this.setMapActiveThreadsMin(10);
        this.setMapActiveThreadsMax(100);
        this.setMapQueuedThreadsMax(200);
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public boolean isEnabledHttp() {
        return this.enabledHttp;
    }

    public void setEnabledHttp(boolean enabledHttp) {
        this.enabledHttp = enabledHttp;
    }

    public MapperServlet getMapperServlet() {
        return this.mapperServlet;
    }

    public void setMapperServlet(MapperServlet mapperServlet) {
        this.mapperServlet = mapperServlet;
    }

    public String getWebappsDirectory() {
        return this.webappsDirectory;
    }

    public void setWebappsDirectory(String webappsDirectory) {
        this.webappsDirectory = webappsDirectory;
    }

    public SSLOptions getSsloptions() {
        return this.ssloptions;
    }

    public void setSsloptions(SSLOptions ssloptions) {
        this.ssloptions = ssloptions;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String toString() {
        return "{'" + this.hostname + "', " + this.httpPort + ", " + this.httpsPort + ", " + this.enabledHttp + ", " + this.mapperServlet + ", '" + this.webappsDirectory + "', " + this.ssloptions + ", '" + this.logFile + "', '" + this.warFile + "'}";
    }

    public void checkConfiguration() throws InitException {
        this.mapperServlet.checkConfiguration();
        if (this.warFile == null) {
            throw new InitException("war file is null!");
        }
        if (!this.warFile.exists()) {
            throw new InitException("war file does not exist!");
        }
        if (this.hostname.isEmpty()) {
            throw new InitException("gridhttps hostname is empty!");
        }
        if (this.logFile.isEmpty()) {
            throw new InitException("gridhttps log filename is empty!");
        }
        if (this.webappsDirectory.isEmpty()) {
            throw new InitException("gridhttps webapps directory is empty!");
        }
        if (this.httpPort <= 0) {
            throw new InitException("gridhttps http port is " + this.httpPort + "!");
        }
        if (this.httpsPort == 0) {
            throw new InitException("gridhttps https port is " + this.httpsPort + "!");
        }
        if (this.httpsPort == this.httpPort) {
            throw new InitException("gridhttps http and https port are equal!");
        }
        if (this.ssloptions.getCertificateFile().isEmpty()) {
            throw new InitException("gridhttps ssloptions host certificate file is empty!");
        }
        if (this.ssloptions.getKeyFile().isEmpty()) {
            throw new InitException("gridhttps ssloptions host key file is empty!");
        }
        if (this.ssloptions.getTrustStoreDirectory().isEmpty()) {
            throw new InitException("gridhttps ssloptions trust store directory is empty!");
        }
        if (this.mapActiveThreadsMax <= 0) {
            throw new InitException("maximum number of threads for mapping-servlet's requests is not valid!");
        }
        if (this.davActiveThreadsMax <= 0) {
            throw new InitException("maximum number of threads for webdav-server's requests is not valid!");
        }
    }

    public File getWarFile() {
        return this.warFile;
    }

    public void setWarFile(File warFile) {
        this.warFile = warFile;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public void setRootDirectory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getWebdavContextPath() {
        return this.webdavContextPath;
    }

    public void setWebdavContextPath(String webdavContextPath) {
        this.webdavContextPath = webdavContextPath;
    }

    public String getFiletransferContextPath() {
        return this.filetransferContextPath;
    }

    public void setFiletransferContextPath(String filetransferContextPath) {
        this.filetransferContextPath = filetransferContextPath;
    }

    public boolean isComputeChecksum() {
        return this.computeChecksum;
    }

    public void setComputeChecksum(boolean computeChecksum) {
        this.computeChecksum = computeChecksum;
    }

    public String getChecksumType() {
        return this.checksumType;
    }

    public void setChecksumType(String checksumType) {
        this.checksumType = checksumType;
    }

    public int getMapQueuedThreadsMax() {
        return this.mapQueuedThreadsMax;
    }

    public void setMapQueuedThreadsMax(int mapQueuedThreadsMax) {
        this.mapQueuedThreadsMax = mapQueuedThreadsMax;
    }

    public int getDavQueuedThreadsMax() {
        return this.davQueuedThreadsMax;
    }

    public void setDavQueuedThreadsMax(int davQueuedThreadsMax) {
        this.davQueuedThreadsMax = davQueuedThreadsMax;
    }

    public int getMapActiveThreadsMin() {
        return this.mapActiveThreadsMin;
    }

    public void setMapActiveThreadsMin(int mapActiveThreadsMin) {
        this.mapActiveThreadsMin = mapActiveThreadsMin;
    }

    public int getMapActiveThreadsMax() {
        return this.mapActiveThreadsMax;
    }

    public void setMapActiveThreadsMax(int mapActiveThreadsMax) {
        this.mapActiveThreadsMax = mapActiveThreadsMax;
    }

    public int getDavActiveThreadsMax() {
        return this.davActiveThreadsMax;
    }

    public void setDavActiveThreadsMax(int davActiveThreadsMax) {
        this.davActiveThreadsMax = davActiveThreadsMax;
    }
}

