/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.gridhttps.server;

import it.grid.storm.gridhttps.server.WebApp;
import it.grid.storm.gridhttps.server.data.StormBackend;
import it.grid.storm.gridhttps.server.data.StormFrontend;
import it.grid.storm.gridhttps.server.data.StormGridhttps;
import it.grid.storm.gridhttps.server.exceptions.ServerException;
import it.grid.storm.gridhttps.server.mapperservlet.MapperServlet;
import it.grid.storm.gridhttps.server.utils.WebNamespaceContext;
import it.grid.storm.gridhttps.server.utils.XML;
import it.grid.storm.gridhttps.server.utils.Zip;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.italiangrid.utils.https.ServerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StormGridhttpsServer {
    private static final int MAX_IDLE_TIME = 30000;
    private static final Logger log = LoggerFactory.getLogger(StormGridhttpsServer.class);
    private StormBackend backendInfo;
    private StormFrontend frontendInfo;
    private StormGridhttps gridhttpsInfo;
    private Server davServer;
    private Server mapServer;
    private ContextHandlerCollection contextHandlerCollection;
    private WebApp webapp;
    private MapperServlet mapperServlet;

    public StormGridhttpsServer(StormGridhttps gridhttpsInfo, StormBackend backendInfo, StormFrontend frontendInfo) throws ServerException {
        this.setGridhttpsInfo(gridhttpsInfo);
        this.setBackendInfo(backendInfo);
        this.setFrontendInfo(frontendInfo);
        this.createDavServer();
        this.createMapServer();
        this.initDavServer();
        this.initMapServer();
    }

    private void createMapServer() {
        this.mapServer = new Server(this.gridhttpsInfo.getMapperServlet().getPort());
        this.mapServer.setStopAtShutdown(true);
        this.mapServer.setGracefulShutdown(1000);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxIdleTimeMs(20000);
        threadPool.setMinThreads(this.gridhttpsInfo.getMapActiveThreadsMin());
        threadPool.setMaxThreads(this.gridhttpsInfo.getMapActiveThreadsMax());
        threadPool.setMaxQueued(this.gridhttpsInfo.getMapQueuedThreadsMax());
        this.mapServer.setThreadPool(threadPool);
    }

    private void createDavServer() {
        this.davServer = ServerFactory.newServer(this.gridhttpsInfo.getHostname(), this.gridhttpsInfo.getHttpsPort(), this.gridhttpsInfo.getSsloptions());
        this.davServer.setStopAtShutdown(true);
        this.davServer.setGracefulShutdown(1000);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxIdleTimeMs(20000);
        threadPool.setMaxThreads(this.gridhttpsInfo.getDavActiveThreadsMax());
        threadPool.setMaxQueued(this.gridhttpsInfo.getDavQueuedThreadsMax());
        this.davServer.setThreadPool(threadPool);
        HandlerCollection hc = new HandlerCollection();
        this.contextHandlerCollection = new ContextHandlerCollection();
        hc.setHandlers(new Handler[]{this.contextHandlerCollection});
        this.davServer.setHandler(hc);
        if (this.gridhttpsInfo.isEnabledHttp()) {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(this.gridhttpsInfo.getHttpPort());
            connector.setMaxIdleTime(30000);
            this.davServer.addConnector(connector);
        }
    }

    private void initDavServer() throws ServerException {
        this.initWebapp();
    }

    private void initMapServer() throws ServerException {
        this.initMapperServlet();
    }

    private String getMappingContextPath() {
        return File.separator + this.gridhttpsInfo.getMapperServlet().getContextPath() + File.separator + this.gridhttpsInfo.getMapperServlet().getContextSpec();
    }

    private String getFileTransferContextPath() {
        return File.separator + this.gridhttpsInfo.getFiletransferContextPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initWebapp() throws ServerException {
        this.webapp = new WebApp(new File(this.gridhttpsInfo.getWebappsDirectory(), "gridhttps-server/webapp"));
        if (this.webapp == null) {
            log.error("Error on webapp creation - webapp is null!");
            throw new ServerException("Error on webapp creation - webapp is null!");
        }
        if (this.webapp.getResourceBase().exists()) {
            log.error("'" + this.webapp.getResourceBase() + "' already exists!");
            throw new ServerException("'" + this.webapp.getResourceBase() + "' already exists!");
        }
        if (!this.webapp.getResourceBase().mkdirs()) {
            log.error("Error on creation of '" + this.webapp.getResourceBase() + "' directory!");
            throw new ServerException("Error on creation of '" + this.webapp.getResourceBase() + "' directory!");
        }
        try {
            Zip.unzip(this.gridhttpsInfo.getWarFile().toString(), this.webapp.getResourceBase().toString());
        }
        catch (IOException e) {
            throw new ServerException(e);
        }
        String[] davExcluded = new String[]{"/index.jsp", this.getFileTransferContextPath(), this.getMappingContextPath()};
        String[] ftExcluded = new String[]{"/index.jsp", this.getMappingContextPath()};
        this.configureDescriptor(this.webapp.getDescriptorFile(), this.generateParams(), davExcluded, ftExcluded);
        this.contextHandlerCollection.addHandler(this.getWebappContext());
    }

    private WebAppContext getWebappContext() {
        WebAppContext context = new WebAppContext();
        context.setDescriptor(this.webapp.getDescriptorFile().toString());
        context.setResourceBase(this.webapp.getResourceBase().getAbsolutePath());
        context.setParentLoaderPriority(true);
        return context;
    }

    private void initMapperServlet() throws ServerException {
        this.mapperServlet = new MapperServlet();
        if (this.mapperServlet == null) {
            log.error("Error on mapper-servlet creation - mapper-servlet is null!");
            throw new ServerException("Error on mapper-servlet creation - mapper-servlet is null!");
        }
        this.mapServer.setHandler(this.getMapperServletContext());
    }

    private ServletContextHandler getMapperServletContext() {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(File.separator + this.gridhttpsInfo.getMapperServlet().getContextPath());
        context.addServlet(new ServletHolder(this.mapperServlet), File.separator + this.gridhttpsInfo.getMapperServlet().getContextSpec());
        return context;
    }

    public void start() throws ServerException {
        try {
            this.davServer.start();
            this.mapServer.start();
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
        log.info("gridhttps-server started ");
    }

    public boolean isRunning() {
        return this.davServer.isRunning() && this.mapServer.isRunning();
    }

    public void stop() throws ServerException {
        if (this.isRunning()) {
            this.undeploy();
            try {
                this.davServer.stop();
                this.mapServer.stop();
            }
            catch (Exception e) {
                throw new ServerException(e);
            }
            log.info("gridhttps-server stopped ");
        }
    }

    public void status() {
        if (this.isRunning()) {
            log.info("gridhttps-server is listening on port " + this.gridhttpsInfo.getHttpsPort() + " (secure connection)");
            if (this.gridhttpsInfo.isEnabledHttp()) {
                log.info("gridhttps-server is listening on port " + this.gridhttpsInfo.getHttpPort() + " (anonymous connection)");
            }
            log.info("mapping-service is listening on port " + this.gridhttpsInfo.getMapperServlet().getPort());
        } else {
            log.info("gridhttps-server is not running ");
            log.info("mapping-service is not running ");
        }
    }

    private void undeploy() throws ServerException {
        log.debug(" - undeploying webapp...");
        this.contextHandlerCollection.removeHandler(this.getWebappContext());
    }

    private void configureDescriptor(File descriptorFile, Map<String, String> params, String[] davExcluded, String[] ftExcluded) throws ServerException {
        String query1 = "/j2ee:web-app/j2ee:filter[@id='stormAuthorizationFilter']/j2ee:init-param/j2ee:param-value";
        String query2 = "/j2ee:web-app/j2ee:filter[@id='webdavSpringMiltonFilter']/j2ee:init-param/j2ee:param-value";
        String query3 = "/j2ee:web-app/j2ee:filter[@id='fileTransferSpringMiltonFilter']/j2ee:init-param/j2ee:param-value";
        try {
            XML doc = new XML(descriptorFile);
            NodeList nodes = doc.getNodes(query1, new WebNamespaceContext(null));
            ((Element)nodes.item(0)).setTextContent(JSON.toString(params));
            nodes = doc.getNodes(query2, new WebNamespaceContext(null));
            String result = Arrays.asList(davExcluded).toString().replaceAll("(^\\[|\\]$)", "").replace(", ", ",");
            ((Element)nodes.item(0)).setTextContent(result);
            nodes = doc.getNodes(query3, new WebNamespaceContext(null));
            result = Arrays.asList(ftExcluded).toString().replaceAll("(^\\[|\\]$)", "").replace(", ", ",");
            ((Element)nodes.item(0)).setTextContent(result);
            doc.save();
        }
        catch (Exception e) {
            throw new ServerException(e);
        }
    }

    private Map<String, String> generateParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("BACKEND_HOSTNAME", this.getBackendInfo().getHostname());
        params.put("BACKEND_PORT", String.valueOf(this.getBackendInfo().getPort()));
        params.put("BACKEND_SERVICE_PORT", String.valueOf(this.getBackendInfo().getServicePort()));
        params.put("FRONTEND_HOSTNAME", this.getFrontendInfo().getHostname());
        params.put("FRONTEND_PORT", String.valueOf(this.getFrontendInfo().getPort()));
        params.put("GPFS_ROOT_DIRECTORY", this.getGridhttpsInfo().getRootDirectory().getAbsolutePath());
        params.put("WEBDAV_CONTEXTPATH", this.getGridhttpsInfo().getWebdavContextPath());
        params.put("FILETRANSFER_CONTEXTPATH", this.getGridhttpsInfo().getFiletransferContextPath());
        params.put("COMPUTE_CHECKSUM", String.valueOf(this.getGridhttpsInfo().isComputeChecksum()));
        params.put("CHECKSUM_TYPE", this.getGridhttpsInfo().getChecksumType());
        return params;
    }

    private StormGridhttps getGridhttpsInfo() {
        return this.gridhttpsInfo;
    }

    private void setGridhttpsInfo(StormGridhttps gridhttpsInfo) {
        this.gridhttpsInfo = gridhttpsInfo;
    }

    private StormBackend getBackendInfo() {
        return this.backendInfo;
    }

    private void setBackendInfo(StormBackend backendInfo) {
        this.backendInfo = backendInfo;
    }

    private StormFrontend getFrontendInfo() {
        return this.frontendInfo;
    }

    private void setFrontendInfo(StormFrontend frontendInfo) {
        this.frontendInfo = frontendInfo;
    }
}

