/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath.bc;

import eu.emi.security.authn.x509.ValidationErrorCode;
import eu.emi.security.authn.x509.helpers.pkipath.SimpleValidationErrorException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.x509.ExtendedPKIXBuilderParameters;
import org.bouncycastle.x509.ExtendedPKIXParameters;
import org.bouncycastle.x509.X509AttributeCertificate;
import org.bouncycastle.x509.X509CRLStoreSelector;

public class CertPathValidatorUtilities
extends org.bouncycastle.jce.provider.CertPathValidatorUtilities {
    public static TrustAnchor findTrustAnchor(X509Certificate cert, Set<?> trustAnchors, String sigProvider) throws AnnotatedException {
        return org.bouncycastle.jce.provider.CertPathValidatorUtilities.findTrustAnchor(cert, trustAnchors, sigProvider);
    }

    public static void addAdditionalStoresFromAltNames(X509Certificate cert, ExtendedPKIXParameters pkixParams) throws CertificateParsingException {
        org.bouncycastle.jce.provider.CertPathValidatorUtilities.addAdditionalStoresFromAltNames(cert, pkixParams);
    }

    public static Collection<?> findIssuerCerts(X509Certificate cert, ExtendedPKIXBuilderParameters pkixParams) throws AnnotatedException {
        return org.bouncycastle.jce.provider.CertPathValidatorUtilities.findIssuerCerts(cert, pkixParams);
    }

    protected static Set<?> getCompleteCRLs2(DistributionPoint dp, Object cert, Date currentDate, ExtendedPKIXParameters paramsPKIX) throws SimpleValidationErrorException {
        try {
            return org.bouncycastle.jce.provider.CertPathValidatorUtilities.getCompleteCRLs(dp, cert, currentDate, paramsPKIX);
        }
        catch (AnnotatedException e) {
            if (e.getMessage().startsWith("No CRLs found for issuer")) {
                throw new SimpleValidationErrorException(ValidationErrorCode.noValidCrlFound, e);
            }
            throw new SimpleValidationErrorException(ValidationErrorCode.crlExtractionError, e.getCause().getMessage(), e.getCause(), e.getCause().getClass().getName());
        }
    }

    protected static Set<X509CRL> getDeltaCRLs2(Date currentDate, ExtendedPKIXParameters paramsPKIX, X509CRL completeCRL) throws SimpleValidationErrorException {
        Set temp;
        X509CRLStoreSelector deltaSelect = new X509CRLStoreSelector();
        try {
            deltaSelect.addIssuerName(CertPathValidatorUtilities.getIssuerPrincipal(completeCRL).getEncoded());
        }
        catch (IOException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlIssuerException, e);
        }
        BigInteger completeCRLNumber = null;
        try {
            DERObject derObject = CertPathValidatorUtilities.getExtensionValue(completeCRL, CRL_NUMBER);
            if (derObject != null) {
                completeCRLNumber = CRLNumber.getInstance(derObject).getPositiveValue();
            }
        }
        catch (Exception e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlNbrExtError, e);
        }
        byte[] idp = null;
        try {
            idp = completeCRL.getExtensionValue(ISSUING_DISTRIBUTION_POINT);
        }
        catch (Exception e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlIssuerException, e);
        }
        deltaSelect.setMinCRLNumber(completeCRLNumber == null ? null : completeCRLNumber.add(BigInteger.valueOf(1L)));
        deltaSelect.setIssuingDistributionPoint(idp);
        deltaSelect.setIssuingDistributionPointEnabled(true);
        deltaSelect.setMaxBaseCRLNumber(completeCRLNumber);
        try {
            temp = CRL_UTIL.findCRLs(deltaSelect, paramsPKIX, currentDate);
        }
        catch (AnnotatedException e) {
            throw new SimpleValidationErrorException(ValidationErrorCode.crlExtractionError, e.getCause() != null && e.getCause().getCause() != null ? e.getCause().getCause() : e, e, e.getMessage());
        }
        HashSet<X509CRL> result = new HashSet<X509CRL>();
        for (X509CRL crl : temp) {
            if (!CertPathValidatorUtilities.isDeltaCRL(crl)) continue;
            result.add(crl);
        }
        return result;
    }

    private static boolean isDeltaCRL(X509CRL crl) {
        Set<String> critical = crl.getCriticalExtensionOIDs();
        return critical != null && critical.contains(X509Extensions.DeltaCRLIndicator.getId());
    }

    protected static DERObject getExtensionValue(X509Extension ext, String oid) throws AnnotatedException {
        return org.bouncycastle.jce.provider.CertPathValidatorUtilities.getExtensionValue(ext, oid);
    }

    protected static void addAdditionalStoresFromCRLDistributionPoint(CRLDistPoint crldp, ExtendedPKIXParameters pkixParams) throws AnnotatedException {
        org.bouncycastle.jce.provider.CertPathValidatorUtilities.addAdditionalStoresFromCRLDistributionPoint(crldp, pkixParams);
    }

    public static BigInteger getSerialNumber(Object cert) {
        if (cert instanceof X509Certificate) {
            return ((X509Certificate)cert).getSerialNumber();
        }
        return ((X509AttributeCertificate)cert).getSerialNumber();
    }

    protected static X500Principal getEncodedIssuerPrincipal(Object cert) {
        return org.bouncycastle.jce.provider.CertPathValidatorUtilities.getEncodedIssuerPrincipal(cert);
    }
}

