/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.BinaryCertChainValidator;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResponseStructure;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResult;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPReqGenerator;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.util.encoders.Base64;

public class OCSPClientImpl {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final int MAX_RESPONSE_SIZE = 20480;

    public OCSPResult queryForCertificate(URL responder, X509Certificate toCheckCert, X509Certificate issuerCert, X509Credential requester, boolean addNonce, int timeout) throws IOException, OCSPException {
        OCSPReq request = this.createRequest(toCheckCert, issuerCert, requester, addNonce);
        OCSPResp response = this.send(responder, request, timeout).getResponse();
        byte[] nonce = null;
        if (addNonce) {
            nonce = OCSPClientImpl.extractNonce(request);
        }
        SingleResp resp = this.verifyResponse(response, toCheckCert, issuerCert, nonce);
        return new OCSPResult(resp);
    }

    public OCSPReq createRequest(X509Certificate toCheckCert, X509Certificate issuerCert, X509Credential requester, boolean addNonce) throws OCSPException {
        OCSPReqGenerator generator = new OCSPReqGenerator();
        CertificateID certId = new CertificateID("1.3.14.3.2.26", issuerCert, toCheckCert.getSerialNumber());
        generator.addRequest(certId);
        if (addNonce) {
            Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
            Vector<X509Extension> values = new Vector<X509Extension>();
            byte[] nonce = new byte[16];
            Random rand = new Random();
            rand.nextBytes(nonce);
            oids.addElement(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
            values.addElement(new X509Extension(false, (ASN1OctetString)new DEROctetString(nonce)));
            generator.setRequestExtensions(new X509Extensions(oids, values));
        }
        if (requester != null) {
            generator.setRequestorName(requester.getCertificate().getSubjectX500Principal());
            try {
                return generator.generate(requester.getCertificate().getSigAlgOID(), requester.getKey(), null, BouncyCastleProvider.PROVIDER_NAME);
            }
            catch (NoSuchProviderException e) {
                throw new RuntimeException("Bug: BC provider not initialized", e);
            }
            catch (IllegalArgumentException e) {
                throw new OCSPException("Unsupported signing algorithm when creating a OCSP request?", e);
            }
        }
        return generator.generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCSPResponseStructure send(URL responder, OCSPReq requestO, int timeout) throws IOException {
        InputStream in = null;
        byte[] request = requestO.getEncoded();
        byte[] response = null;
        Date maxCache = null;
        HttpURLConnection con = null;
        try {
            int total;
            String getUrl = this.getHttpGetUrl(responder, request);
            if (getUrl == null) {
                con = this.doPost(responder, request, timeout);
            } else {
                URL u = new URL(getUrl);
                con = (HttpURLConnection)u.openConnection();
                this.configureHttpConnection(con, timeout);
            }
            in = con.getInputStream();
            int contentLength = con.getContentLength();
            if (contentLength == -1 || contentLength > 20480) {
                contentLength = 20480;
            }
            maxCache = OCSPClientImpl.getNextUpdateFromCacheHeader(con.getHeaderField("cache-control"));
            response = new byte[contentLength];
            int count = 0;
            for (total = 0; total < contentLength && (count = in.read(response, total, response.length - total)) >= 0; total += count) {
            }
            if (count >= 0 && in.read() >= 0) {
                throw new IOException("OCSP response size exceeded the upper limit of 20480");
            }
            if (total != contentLength) {
                response = Arrays.copyOf(response, total);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        OCSPResp resp = new OCSPResp(response);
        return new OCSPResponseStructure(resp, maxCache);
    }

    private void configureHttpConnection(HttpURLConnection con, int timeout) {
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection httpsCon = (HttpsURLConnection)con;
            BinaryCertChainValidator trustAll = new BinaryCertChainValidator(true);
            SSLSocketFactory sf = SocketFactoryCreator.getSocketFactory(null, trustAll);
            httpsCon.setSSLSocketFactory(sf);
        }
        con.setConnectTimeout(timeout);
        con.setReadTimeout(timeout);
    }

    private String getHttpGetUrl(URL responder, byte[] request) {
        if (responder.toExternalForm().length() + request.length > 255) {
            return null;
        }
        byte[] base64 = Base64.encode(request);
        String ret = new String(base64, ASCII);
        try {
            ret = URLEncoder.encode(ret, ASCII.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("US-ASCII encoding is not known?", e);
        }
        String url = responder.toExternalForm();
        ret = url.endsWith("/") ? url + ret : url + "/" + ret;
        if (ret.length() > 255) {
            return null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection doPost(URL responder, byte[] request, int timeout) throws IOException {
        HttpURLConnection con = (HttpURLConnection)responder.openConnection();
        this.configureHttpConnection(con, timeout);
        OutputStream out = null;
        try {
            con.setDoOutput(true);
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/ocsp-request");
            con.setRequestProperty("Content-length", String.valueOf(request.length));
            out = con.getOutputStream();
            out.write(request);
            out.flush();
            HttpURLConnection httpURLConnection = con;
            return httpURLConnection;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static Date getNextUpdateFromCacheHeader(String cc) {
        int delta;
        if (cc == null) {
            return null;
        }
        int i = cc.indexOf("max-age=");
        if (i == -1) {
            return null;
        }
        int j = cc.indexOf(",", i += 8);
        if (j == -1) {
            j = cc.length();
        }
        String deltaS = cc.substring(i, j).trim();
        try {
            delta = Integer.parseInt(deltaS);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Date(System.currentTimeMillis() + (long)delta * 1000L);
    }

    private static String getResponderErrorDesc(int errorNo) {
        switch (errorNo) {
            case 2: {
                return "internal server error";
            }
            case 1: {
                return "malformed request";
            }
            case 5: {
                return "request is required to be signed";
            }
            case 3: {
                return "try again later";
            }
            case 6: {
                return "request was not authorized";
            }
        }
        return "unknown error";
    }

    public SingleResp verifyResponse(OCSPResp response, X509Certificate toCheckCert, X509Certificate issuerCert, byte[] checkNonce) throws OCSPException {
        if (response.getStatus() != 0) {
            throw new OCSPException("Responder returned an error: " + OCSPClientImpl.getResponderErrorDesc(response.getStatus()));
        }
        Object respO = response.getResponseObject();
        if (!(respO instanceof BasicOCSPResp)) {
            throw new OCSPException("Only Basic OCSP response type is supported");
        }
        BasicOCSPResp bresp = (BasicOCSPResp)respO;
        if (checkNonce != null) {
            ASN1OctetString octs;
            byte[] nonceAsn = bresp.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId());
            if (nonceAsn == null) {
                throw new OCSPException("Nonce was sent and is required but did not get it in reply");
            }
            try {
                octs = (ASN1OctetString)ASN1Object.fromByteArray(nonceAsn);
            }
            catch (Exception e) {
                throw new OCSPException("Nonce received with the reply is invalid, unable to parse it", e);
            }
            byte[] nonce = octs.getOctets();
            if (!Arrays.equals(nonce, checkNonce)) {
                throw new OCSPException("Received nonce doesn't match the one sent to the server. Sent: " + Arrays.toString(checkNonce) + " received: " + Arrays.toString(nonce));
            }
        }
        PublicKey key = this.establishResponsePubKey(bresp, issuerCert);
        try {
            if (!bresp.verify(key, BouncyCastleProvider.PROVIDER_NAME)) {
                throw new OCSPException("Failed to verify the OCSP response signature. It is corrupted or faked");
            }
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Bug, BC provider is not available?", e);
        }
        if (bresp.hasUnsupportedCriticalExtension()) {
            throw new OCSPException("OCSP contains unsupported critical extensions: " + bresp.getCriticalExtensionOIDs());
        }
        SingleResp[] resps = bresp.getResponses();
        for (int i = 0; i < resps.length; ++i) {
            SingleResp sResp = resps[i];
            if (sResp.hasUnsupportedCriticalExtension()) {
                throw new OCSPException("OCSP SingleResponse contains unsupported critical extensions: " + sResp.getCriticalExtensionOIDs());
            }
            if (!this.checkCertIDMatching(toCheckCert, issuerCert, sResp.getCertID())) continue;
            this.verifyTimeRange(sResp.getThisUpdate(), sResp.getNextUpdate());
            return sResp;
        }
        throw new OCSPException("Received a correct answer from OCSP responder, but it didn't contain any information on the certificate being checked");
    }

    private void verifyTimeRange(Date thisUpdate, Date nextUpdate) throws OCSPException {
        Date now = new Date();
        if (thisUpdate == null) {
            throw new OCSPException("Malformed OCSP response, no thisUpdate time");
        }
        if (nextUpdate == null) {
            throw new OCSPException("Unsupported OCSP response, no nextUpdate time (required by RFC 5019)");
        }
        int tolerance = 120000;
        Date futureNow = new Date(now.getTime() + (long)tolerance);
        Date pastNow = new Date(now.getTime() - (long)tolerance);
        if (futureNow.before(thisUpdate)) {
            throw new OCSPException("Response is not yet valid, will be from: " + thisUpdate);
        }
        if (pastNow.after(nextUpdate)) {
            throw new OCSPException("Response has expired on: " + nextUpdate);
        }
    }

    private boolean checkCertIDMatching(X509Certificate toFind, X509Certificate issuerCert, CertificateID checkedCertId) throws OCSPException {
        CertificateID certId = new CertificateID(checkedCertId.getHashAlgOID(), issuerCert, toFind.getSerialNumber());
        return certId.equals(checkedCertId);
    }

    private PublicKey establishResponsePubKey(BasicOCSPResp bresp, X509Certificate issuerCert) throws OCSPException {
        X509Certificate[] signerCerts;
        try {
            signerCerts = bresp.getCerts(BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Bug, BC provider is not available?", e);
        }
        if (signerCerts == null || signerCerts.length == 0) {
            return issuerCert.getPublicKey();
        }
        X509Certificate signerCert = signerCerts[0];
        if (signerCert.equals(issuerCert)) {
            return issuerCert.getPublicKey();
        }
        if (!issuerCert.getSubjectX500Principal().equals(signerCert.getIssuerX500Principal())) {
            throw new OCSPException("Response is signed by an untrusted/invalid entity: " + CertificateUtils.format(signerCert, FormatMode.COMPACT_ONE_LINE));
        }
        try {
            List<String> keyUsage = signerCert.getExtendedKeyUsage();
            if (keyUsage == null || !keyUsage.contains(KeyPurposeId.id_kp_OCSPSigning.getId())) {
                throw new OCSPException("Response is signed by an entity which does not have the OCSP delegation from the CA (no flag in ExtendedKeyUsage)");
            }
        }
        catch (CertificateParsingException e) {
            throw new OCSPException("Response contains an unparsable certificate (ExtendedKeyUsage)", e);
        }
        try {
            signerCert.verify(issuerCert.getPublicKey(), BouncyCastleProvider.PROVIDER_NAME);
        }
        catch (Exception e) {
            throw new OCSPException("Response contains a certificate which is improperly signed, it is faked or corrupted: " + e.getMessage(), e);
        }
        return signerCert.getPublicKey();
    }

    public static byte[] extractNonce(OCSPReq request) {
        ASN1OctetString octs;
        byte[] nonceAsn = request.getExtensionValue(OCSPObjectIdentifiers.id_pkix_ocsp_nonce.getId());
        if (nonceAsn == null) {
            return null;
        }
        try {
            octs = (ASN1OctetString)ASN1Object.fromByteArray(nonceAsn);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't decode nonce encoded in request", e);
        }
        return octs.getOctets();
    }
}

