/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.ns.NamespacesStore;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public class GlobusNamespacesStore
implements NamespacesStore {
    protected Map<String, List<NamespacePolicy>> policiesByName = new HashMap<String, List<NamespacePolicy>>(1);

    @Override
    public synchronized void setPolicies(List<NamespacePolicy> policies) {
        this.policiesByName = new HashMap<String, List<NamespacePolicy>>(20);
        for (NamespacePolicy policy : policies) {
            this.addGlobusPolicy(policy);
        }
    }

    protected void addGlobusPolicy(NamespacePolicy policy) {
        String issuer = policy.getIssuer();
        List<NamespacePolicy> current = this.policiesByName.get(issuer);
        if (current == null) {
            current = new ArrayList<NamespacePolicy>();
            this.policiesByName.put(issuer, current);
        }
        current.add(policy);
    }

    @Override
    public synchronized List<NamespacePolicy> getPolicies(X500Principal subject) {
        String dn = OpensslNameUtils.convertFromRfc2253(subject.getName(), false);
        return this.policiesByName.get(OpensslNameUtils.normalize(dn));
    }
}

