/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.completors;

import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.ArgumentCompletor;
import jline.Completor;
import jline.SimpleCompletor;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class CommandMultiplexedCompletor
implements Completor {
    private static final Logger log = Logger.getLogger(CommandMultiplexedCompletor.class);
    private final ShellContext shellContext;
    private final Map<String, Completor> commandCompletors;

    public CommandMultiplexedCompletor(ShellContext _ctx) {
        this.shellContext = _ctx;
        this.commandCompletors = new HashMap<String, Completor>();
    }

    public int complete(String _buffer, int _cursor, List _candidates) {
        String tBuffer;
        String[] bufferEles;
        if (log.isDebugEnabled()) {
            log.debug((Object)("_buffer: " + _buffer));
            log.debug((Object)("_cursor: " + _cursor));
            log.debug((Object)("_candis: " + _candidates));
        }
        if ((bufferEles = (tBuffer = _buffer.trim()).split(" ")).length > 0) {
            ShellCommand cmd;
            String currentCommand = bufferEles[0];
            if (log.isDebugEnabled()) {
                log.debug((Object)("current command is: " + currentCommand));
            }
            if ((cmd = this.shellContext.getCommand(currentCommand)) != null) {
                Completor cmdCompletor;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("command object from context: " + cmd));
                }
                if ((cmdCompletor = this.getCommandCompletor(cmd)) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("cmdCompletor: " + cmdCompletor));
                    }
                    return cmdCompletor.complete(_buffer, _cursor, _candidates);
                }
            }
        }
        return 0;
    }

    private Completor getCommandCompletor(ShellCommand cmd) {
        Options cmdOpts;
        Completor commandCompletor = this.commandCompletors.get(cmd.getName());
        if (commandCompletor == null && (cmdOpts = cmd.getOptions()) != null) {
            ArrayList<String> optionStrings = new ArrayList<String>();
            for (Option option : cmdOpts.getOptions()) {
                optionStrings.add("-" + option.getOpt());
                optionStrings.add("--" + option.getLongOpt());
            }
            if (log.isDebugEnabled()) {
                log.debug(optionStrings);
            }
            commandCompletor = new ArgumentCompletor(new Completor[]{new SimpleCompletor(optionStrings.toArray(new String[optionStrings.size()]))});
            this.commandCompletors.put(cmd.getName(), commandCompletor);
        }
        return commandCompletor;
    }
}

