/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.grid.Job;
import eu.unicore.hila.grid.TaskStatus;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Start
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Start.class);

    public Start() {
        this.initializeOptions();
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) throws HiLAException {
        try {
            CommandLine cmdLine = this.parser.parse(this.options, cmdArgs);
            if (cmdLine.hasOption("h")) {
                this.printHelp(ctx);
                return;
            }
            List arguments = cmdLine.getArgList();
            arguments.remove(0);
            ArrayList<Job> tasks = new ArrayList<Job>();
            for (String taskLocation : arguments) {
                Location location = new Location(taskLocation);
                if (!location.isLocationOfType(Job.class)) {
                    location = ctx.getCurrentLocation().getChildLocation(taskLocation);
                }
                if (location.isLocationOfType(Job.class)) {
                    Job task = (Job)location.locate(new Object[0]);
                    if (task != null) {
                        tasks.add(task);
                        continue;
                    }
                    log.warn((Object)(taskLocation + " does not exist."));
                    continue;
                }
                log.warn((Object)(taskLocation + " is not a valid Task location."));
            }
            for (Job task : tasks) {
                task.startASync(new File[0]);
            }
            if (cmdLine.hasOption("b")) {
                String blockMS = cmdLine.getOptionValue("b");
                for (Job computeTask : tasks) {
                    TaskStatus finalStatus = null;
                    if (blockMS == null) {
                        finalStatus = computeTask.block();
                    } else {
                        long block = Long.parseLong(blockMS);
                        finalStatus = computeTask.block(block);
                    }
                    try {
                        ctx.getCs().printString(computeTask.getLocation().toString() + " " + finalStatus.toString());
                        ctx.getCs().printNewline();
                    }
                    catch (IOException e) {
                        log.info((Object)(computeTask.getLocation().toString() + " " + finalStatus.toString()));
                    }
                }
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse command line.", (Throwable)e);
        }
    }

    private void initializeOptions() {
        OptionBuilder.withArgName((String)"h");
        OptionBuilder.withDescription((String)"Print this help message.");
        OptionBuilder.withLongOpt((String)"help");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withArgName((String)"b");
        OptionBuilder.withDescription((String)"Block on task. Optional argument for blocking limited number of ms.");
        OptionBuilder.hasOptionalArgs((int)1);
        OptionBuilder.withArgName((String)"block");
        this.options.addOption(OptionBuilder.create((String)"b"));
    }
}

