/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Import
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Import.class);

    public Import() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        OptionBuilder.withArgName((String)"b");
        OptionBuilder.withDescription((String)"Block on task.");
        OptionBuilder.withLongOpt((String)"block");
        OptionBuilder.hasArg((boolean)false);
        this.options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withArgName((String)"h");
        OptionBuilder.withDescription((String)"Print help message.");
        OptionBuilder.withLongOpt((String)"help");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withArgName((String)"f");
        OptionBuilder.withDescription((String)"Force overwrite");
        OptionBuilder.withLongOpt((String)"force");
        this.options.addOption(OptionBuilder.create((String)"f"));
        this.options.addOption(OptionConstants.RECURSIVE);
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) {
        eu.unicore.hila.grid.File target;
        CommandLine cmdline = null;
        try {
            cmdline = this.parser.parse(this.options, cmdArgs);
            if (cmdline.hasOption("h")) {
                this.printHelp(ctx);
                return;
            }
        }
        catch (ParseException e) {
            log.error((Object)e);
            return;
        }
        List args = cmdline.getArgList();
        args.remove(0);
        String targetPath = (String)args.get(args.size() - 1);
        Location targetLoc = null;
        try {
            targetLoc = new Location(targetPath);
            if (!targetLoc.isLocationOfType(eu.unicore.hila.grid.File.class)) {
                targetLoc = ctx.getCurrentLocation().getChildLocation(targetPath);
            }
            if (!targetLoc.isLocationOfType(eu.unicore.hila.grid.File.class)) {
                log.error((Object)("Target " + targetPath + " is not of type File"));
                return;
            }
        }
        catch (HiLALocationSyntaxException e) {
            log.error((Object)"Last argument is not a valid location.", (Throwable)e);
            return;
        }
        try {
            target = (eu.unicore.hila.grid.File)targetLoc.locate(new Object[0]);
            if (args.size() > 2 && !target.isDirectory()) {
                log.error((Object)"Target must be a directory for multiple import files.");
                return;
            }
        }
        catch (HiLAException e) {
            log.error((Object)("Exception while locating import target " + targetLoc.toString()));
            return;
        }
        ArrayList<File> importFiles = new ArrayList<File>();
        for (int i = 0; i < args.size() - 1; ++i) {
            File f = new File((String)args.get(i));
            if (!f.isAbsolute()) {
                f = new File(ctx.getCurrentLocalDir(), (String)args.get(i));
            }
            if (f.exists()) {
                importFiles.add(f);
                continue;
            }
            log.error((Object)("Import file " + f.getPath() + " does not exist."));
        }
        ArrayList<SimpleTransfer> importList = new ArrayList<SimpleTransfer>();
        for (File localFile : importFiles) {
            try {
                importList.add(target.importFromLocalFile(localFile, cmdline.hasOption(OptionConstants.FORCE.getArgName()), cmdline.hasOption(OptionConstants.RECURSIVE.getArgName())));
            }
            catch (HiLAException e) {
                log.error((Object)("Unable to import " + localFile + " to " + target.getLocation().toString()));
            }
        }
        for (SimpleTransfer simpleTransfer : importList) {
            try {
                log.info((Object)(simpleTransfer.getLocation().toString() + " " + simpleTransfer.status().toString()));
            }
            catch (HiLAException e) {
                log.warn((Object)("Unable to determine status of transfer " + simpleTransfer.getLocation().toString()));
            }
        }
        if (cmdline.hasOption(OptionConstants.BLOCK.getArgName())) {
            for (SimpleTransfer simpleTransfer : importList) {
                try {
                    simpleTransfer.block();
                }
                catch (HiLAException e) {
                    log.error((Object)("Failed to block on " + simpleTransfer.getLocation()));
                }
            }
        }
    }

    @Override
    public String help() {
        StringBuilder sb = new StringBuilder("Import file from the local file system to a remote storage.");
        sb.append(System.getProperty("line.separator"));
        sb.append("import <Local File Path> <Destination File Location>");
        sb.append(System.getProperty("line.separator"));
        return sb.append(super.help()).toString();
    }
}

