/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.shell.commands;

import eu.unicore.hila.Location;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import eu.unicore.hila.grid.SimpleTransfer;
import eu.unicore.hila.shell.ShellContext;
import eu.unicore.hila.shell.commands.OptionConstants;
import eu.unicore.hila.shell.commands.ShellCommand;
import eu.unicore.hila.shell.commands.ShellCommandBase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class Export
extends ShellCommandBase
implements ShellCommand {
    private static final Logger log = Logger.getLogger(Export.class);

    public Export() {
        this.initializeOptions();
    }

    private void initializeOptions() {
        this.options.addOption(OptionConstants.BLOCK);
        this.options.addOption(OptionConstants.HELP);
        this.options.addOption(OptionConstants.FORCE);
        this.options.addOption(OptionConstants.RECURSIVE);
    }

    @Override
    public void execute(String[] cmdArgs, ShellContext ctx) {
        CommandLine cmdline = null;
        try {
            cmdline = this.parser.parse(this.options, cmdArgs);
            if (cmdline.hasOption(OptionConstants.HELP.getOpt())) {
                this.printHelp(ctx);
                return;
            }
        }
        catch (ParseException e) {
            log.error((Object)"Unable to parse command line", (Throwable)e);
            return;
        }
        List args = cmdline.getArgList();
        args.remove(0);
        if (args.size() == 0) {
            log.error((Object)"Nothing to export.");
            return;
        }
        String localPath = (String)args.get(args.size() - 1);
        File localFile = args.size() == 1 ? ctx.getCurrentLocalDir() : new File(localPath);
        if (!localFile.isAbsolute()) {
            localFile = new File(ctx.getCurrentLocalDir(), localPath);
        }
        if (localFile.exists()) {
            if (!localFile.isDirectory()) {
                if (args.size() > 2) {
                    log.error((Object)(localFile.toString() + " is not a directory."));
                    return;
                }
                if (!cmdline.hasOption(OptionConstants.FORCE.getOpt())) {
                    log.error((Object)("Use " + OptionConstants.FORCE.getOpt() + " to overwrite existing file."));
                    return;
                }
            }
        } else {
            if (args.size() > 2) {
                log.error((Object)("Cannot copy multiple files to non-existent directory " + localPath));
                return;
            }
            if (localFile.getParentFile().exists() && !localFile.getParentFile().isDirectory()) {
                log.error((Object)"Cannot create file in given location.");
                return;
            }
        }
        ArrayList<SimpleTransfer> transfers = new ArrayList<SimpleTransfer>();
        for (int i = 0; i < args.size() - 1; ++i) {
            try {
                Location loc = new Location((String)args.get(i));
                if (!loc.isLocationOfType(eu.unicore.hila.grid.File.class)) {
                    loc = ctx.getCurrentLocation().getChildLocation((String)args.get(i));
                }
                if (loc.isLocationOfType(eu.unicore.hila.grid.File.class)) {
                    try {
                        transfers.add(((eu.unicore.hila.grid.File)loc.locate(new Object[0])).exportToLocalFile(localFile, cmdline.hasOption(OptionConstants.FORCE.getArgName()), cmdline.hasOption(OptionConstants.RECURSIVE.getArgName())));
                    }
                    catch (HiLAException e) {
                        log.error((Object)("Export of " + loc.toString() + " failed."), (Throwable)e);
                    }
                    continue;
                }
                log.warn((Object)(loc.toString() + " not of type File."));
                continue;
            }
            catch (HiLALocationSyntaxException e) {
                log.error((Object)"Invalid location syntax, continuing with next location.", (Throwable)e);
            }
        }
        for (SimpleTransfer simpleTransfer : transfers) {
            log.info((Object)simpleTransfer.getLocation());
        }
    }

    @Override
    public String help() {
        StringBuilder sb = new StringBuilder("Export file from a storage to the local file system.");
        sb.append(System.getProperty("line.separator"));
        sb.append("export <Source File Location> <Local File Path>");
        sb.append(System.getProperty("line.separator"));
        return sb.append(super.help()).toString();
    }
}

