/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila.common;

import eu.unicore.hila.Location;
import eu.unicore.hila.Metadata;
import eu.unicore.hila.Resource;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLALocationPatternException;
import eu.unicore.hila.exceptions.HiLANotImplementedException;

public abstract class BaseResource
implements Resource {
    protected final Location location;

    public BaseResource(Location _location) {
        this.location = _location;
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    @Override
    public Resource getChild(String childPath) throws HiLAException {
        Location childLocation = this.location.getChildLocation(childPath);
        return childLocation.locate(new Object[0]);
    }

    @Override
    public Metadata getMetadata() throws HiLAException {
        throw new HiLANotImplementedException("Not implemented");
    }

    @Override
    public String getName() {
        return this.location.getName();
    }

    @Override
    public Resource getParent() throws HiLAException {
        return this.location.getParentLocation().locate(new Object[0]);
    }

    public static Location findParentLocationOfType(Class<? extends Resource> _type, Location _child, Class<? extends Resource> _stopAtType) throws HiLALocationPatternException {
        Location currentLocation = _child;
        while (!currentLocation.isLocationOfType(_type) && !currentLocation.isLocationOfType(_stopAtType)) {
            currentLocation = currentLocation.getParentLocation();
        }
        if (currentLocation.isLocationOfType(_type)) {
            return currentLocation;
        }
        throw new HiLALocationPatternException("No Location of type " + _type + " is parent of: " + _child);
    }

    @Override
    public boolean ok() {
        return true;
    }
}

