/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class PackageUtil {
    public static Set<Class<?>> getClasses(String packageName) throws Exception {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return PackageUtil.getClasses(loader, packageName, true);
    }

    public static Set<Class<?>> getClasses(ClassLoader loader, String packageName, boolean includeSubPackages) throws Exception {
        HashSet classes = new HashSet();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = loader.getResources(path);
        if (resources != null) {
            while (resources.hasMoreElements()) {
                String filePath = resources.nextElement().getFile();
                if (filePath.indexOf("%20") > 0) {
                    filePath = filePath.replaceAll("%20", " ");
                }
                if (filePath == null) continue;
                if (filePath.indexOf("!") > 0 && filePath.indexOf(".jar") > 0) {
                    String jarPath = filePath.substring(0, filePath.indexOf("!")).substring(filePath.indexOf(":") + 1);
                    if (jarPath.indexOf(":") >= 0) {
                        jarPath = jarPath.substring(1);
                    }
                    classes.addAll(PackageUtil.getFromJARFile(loader, jarPath, packageName, includeSubPackages));
                    continue;
                }
                classes.addAll(PackageUtil.getFromDirectory(loader, new File(filePath), packageName, includeSubPackages));
            }
        }
        return classes;
    }

    public static Set<Class<?>> getFromDirectory(ClassLoader loader, File directory, String packageName, boolean includeSubPackages) throws Exception {
        HashSet classes = new HashSet();
        if (directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.getName().endsWith(".class")) {
                    String name = packageName + '.' + PackageUtil.stripFilenameExtension(file.getName());
                    Class<?> clazz = loader.loadClass(name);
                    classes.add(clazz);
                    continue;
                }
                if (!includeSubPackages || !file.isDirectory()) continue;
                classes.addAll(PackageUtil.getFromDirectory(loader, file, packageName + "." + file.getName(), true));
            }
        }
        return classes;
    }

    public static Set<Class<?>> getFromJARFile(ClassLoader loader, String jar, String packageName, boolean includeSubPackages) throws Exception {
        JarEntry jarEntry;
        String path = packageName.replace('.', '/');
        HashSet classes = new HashSet();
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jar));
        do {
            String className;
            if ((jarEntry = jarFile.getNextJarEntry()) == null || !(className = jarEntry.getName()).endsWith(".class") || !(className = PackageUtil.stripFilenameExtension(className)).startsWith(path) || !includeSubPackages && className.split("/").length != path.split("/").length + 1) continue;
            classes.add(loader.loadClass(className.replace('/', '.')));
        } while (jarEntry != null);
        jarFile.close();
        return classes;
    }

    public static String stripFilenameExtension(String _className) {
        int idx;
        int n = idx = _className == null ? -1 : _className.indexOf(46);
        if (idx < 1) {
            return _className;
        }
        return _className.substring(0, idx);
    }
}

