/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.hila;

import eu.unicore.hila.LocationPattern;
import eu.unicore.hila.Resource;
import eu.unicore.hila.ResourceTypeRegistry;
import eu.unicore.hila.exceptions.HiLAException;
import eu.unicore.hila.exceptions.HiLAFactoryException;
import eu.unicore.hila.exceptions.HiLALocationSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Location {
    private static final Logger log;
    private final URI uri;
    private volatile Location parentLocation = null;

    public Location(String stringLocation) throws HiLALocationSyntaxException {
        try {
            this.uri = new URI(stringLocation);
            this.uri.normalize();
        }
        catch (URISyntaxException e) {
            throw new HiLALocationSyntaxException("Invalid HiLA Location.", e);
        }
    }

    public Location(URI uri) {
        this.uri = uri;
        this.uri.normalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getParentLocation() {
        if (this.parentLocation == null) {
            Location location = this;
            synchronized (location) {
                if (this.parentLocation == null) {
                    this.parentLocation = this.getStringValue().charAt(this.getStringValue().length() - 1) == '/' ? new Location(this.uri.resolve("..")) : new Location(this.uri.resolve("."));
                }
            }
        }
        return this.parentLocation;
    }

    public Class<Resource> getLocationType() {
        return ResourceTypeRegistry.getInstance().determineResourceType(this);
    }

    public boolean isLocationOfType(Class type) {
        Class<Resource> actualType = ResourceTypeRegistry.getInstance().determineResourceType(this);
        if (actualType != null) {
            if (actualType.equals(type)) {
                return true;
            }
            return this.implementsOrExtends(type, actualType);
        }
        return false;
    }

    public boolean isAbsolute() {
        return this.uri.isAbsolute();
    }

    private boolean implementsOrExtends(Class type, Class actualType) {
        Class<?>[] interfaces;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Checking whether " + actualType.getName() + " implements or extends " + type.getName()));
        }
        if (type.equals(actualType)) {
            return true;
        }
        for (Class<?> class1 : interfaces = actualType.getInterfaces()) {
            if (!type.equals(class1)) continue;
            return true;
        }
        Class superClass = actualType.getSuperclass();
        if (superClass != null) {
            return this.implementsOrExtends(type, superClass);
        }
        return false;
    }

    public Resource locate(Object ... extraInformation) throws HiLAException {
        Class<Resource> resourceType = ResourceTypeRegistry.getInstance().determineResourceType(this);
        if (resourceType == null) {
            throw new HiLALocationSyntaxException("Unknown resource type.");
        }
        try {
            try {
                Method locateMethod = resourceType.getMethod("locate", Location.class, Array.newInstance(Object.class, 0).getClass());
                Resource resource = (Resource)locateMethod.invoke(null, this, extraInformation);
                return resource;
            }
            catch (NoSuchMethodException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("ResourceType " + resourceType + " does not provide a locate/2 method."));
                }
                try {
                    Method locateMethod = resourceType.getMethod("locate", Location.class);
                    Resource resource = (Resource)locateMethod.invoke(null, this);
                    return resource;
                }
                catch (NoSuchMethodException e1) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("ResourceType " + resourceType + " does not provide a locate/1 method."));
                    }
                }
                catch (SecurityException e1) {
                    throw new HiLAException("Access to resource's locate method denied.", e1);
                }
                catch (IllegalArgumentException e1) {
                    throw new HiLAException("Illegal argument in call to locate method.", e1);
                }
                catch (IllegalAccessException e1) {
                    throw new HiLAException("Access to resource's locate method denied.", e1);
                }
                catch (InvocationTargetException e1) {
                    if (e1.getCause() instanceof HiLAException) {
                        throw (HiLAException)e1.getCause();
                    }
                    throw new HiLAFactoryException("Resource constructor threw an exception.", e1.getCause());
                }
                try {
                    Constructor<Resource> resourceConstructor = resourceType.getConstructor(Location.class);
                    return resourceConstructor.newInstance(this);
                }
                catch (NoSuchMethodException e2) {
                    throw new HiLAFactoryException("Unable to instantiate resource without further information.", e2);
                }
                catch (InstantiationException e3) {
                    throw new HiLAException("Unable to instantiate resource without further information.", e3);
                }
            }
        }
        catch (SecurityException e) {
            throw new HiLAException("Access to resource's constructor denied.", e);
        }
        catch (IllegalArgumentException e) {
            throw new HiLAException("Illegal argument in call to resource's constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new HiLAException("Access to resource's constructor denied.", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof HiLAException) {
                throw (HiLAException)e.getCause();
            }
            throw new HiLAFactoryException("Resource constructor threw an exception.", e);
        }
    }

    public CharSequence getStringValue() {
        return this.toString();
    }

    public String toString() {
        return this.uri.toASCIIString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Location) {
            Location other = (Location)obj;
            if (other.toString().endsWith("/")) {
                try {
                    other = other.getParentLocation().getChildLocation(other.getName());
                }
                catch (HiLALocationSyntaxException e) {
                    return false;
                }
            }
            Location thisAlt = this;
            if (this.toString().endsWith("/")) {
                try {
                    thisAlt = this.getParentLocation().getChildLocation(this.getName());
                }
                catch (HiLALocationSyntaxException e) {
                    return false;
                }
            }
            return thisAlt.uri.equals(other.uri);
        }
        return false;
    }

    public int hashCode() {
        if (this.toString().endsWith("/")) {
            try {
                Location loc2 = this.getParentLocation().getChildLocation(this.getName());
                return loc2.uri.hashCode();
            }
            catch (HiLALocationSyntaxException e) {
                return this.uri.hashCode() + 1;
            }
        }
        return this.uri.hashCode();
    }

    public Location getChildLocation(String childPath) throws HiLALocationSyntaxException {
        if (this.uri.toString().endsWith("/")) {
            return new Location(this.uri.toString().concat(childPath));
        }
        return new Location(this.uri.toString().concat("/".concat(childPath)));
    }

    public String getName() {
        String path = this.uri.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        StringTokenizer tok = new StringTokenizer(path, "/");
        String name = null;
        while (tok.hasMoreTokens()) {
            name = tok.nextToken();
        }
        return name == null ? "" : name;
    }

    public String relativePath(Location _other) {
        URI relative = this.uri.relativize(_other.uri);
        return relative.toString();
    }

    public String getUser() {
        LocationPattern lp = ResourceTypeRegistry.getInstance().determineLocationPattern(this);
        if (lp != null) {
            return lp.fillTemplates(this).get("{user}");
        }
        return null;
    }

    static {
        Properties log4jProps = new Properties();
        try {
            File log4jConf = new File("log4j.properties");
            if (log4jConf.exists()) {
                FileInputStream is = new FileInputStream(log4jConf);
                log4jProps.load(is);
                ((InputStream)is).close();
            } else {
                InputStream is = Location.class.getResourceAsStream("/log4j.properties");
                log4jProps.load(is);
                is.close();
            }
            PropertyConfigurator.configure((Properties)log4jProps);
        }
        catch (IOException e) {
            System.out.println("Unable to setup log4j.");
        }
        log = Logger.getLogger(Location.class);
    }
}

