import exceptions
import os
import logging

from stat import *
from storm.monitoring.sensor.api import units
from storm.monitoring.sensor.api import measure

class PsError(exceptions.Exception):
    pass

class PsRss(object):
    """Checks memory of a given system"""
         
    def __init__(self, pid):
        self.logger = logging.getLogger("storm_sensor.procmem_check")
        self.logger.info("creating an instance of PsRss")

        if type(pid) != int:
            raise PsError('Please provide a pid')
        else:
            rss_mem,unit = self.ps_rss(pid)
            self.rss_mem = measure.Measure(rss_mem, unit, str(pid))
         
    def ps_rss(self, pid):
        """Returns the size of a file"""
        self.logger.info("doing ps rss")
        return int(os.popen('ps -p %s -o rss | tail -l' % pid).readlines()[1].split()[0]), units.Units().kB

    def get_rss_mem(self):
        self.logger.info("getting rss mem information")
        return self.rss_mem
