/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.glite.pseudo.common.http.HttpClientBuilder;
import org.glite.pseudo.server.PseudoServerComponent;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMIRPublisher
implements PseudoServerComponent {
    private static final Logger log = LoggerFactory.getLogger(EMIRPublisher.class);
    public static final String CFG_SECTION_EMIR = "EMIR";
    public static final String ARRAY_DELIMITER = ",";
    private HttpClient httpClient = null;
    private String emirUrl;
    private String serviceId;
    private String serviceName;
    private String serviceType;
    private String serviceEndpointId;
    private String serviceEndpointUrl;
    private String[] serviceEndpointCapability;
    private String[] serviceEndpointTechnology;
    private String serviceEndpointInterfaceName;
    private String serviceEndpointInterfaceVersion;
    private long serviceRecordTtl;

    public EMIRPublisher(Timer timer, PseudoServerConfiguration serverConfiguration) throws PseudoServerException {
        log.debug("Initializing EMIR Publisher..");
        boolean configured = true;
        long publishInterval = 60L;
        try {
            this.emirUrl = EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "emirUrl"), "emirUrl cannot be null!");
            this.serviceId = EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceId"), "serviceId cannot be null!");
            this.serviceName = EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceName"), "serviceName cannot be null!");
            this.serviceType = EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceType"), "serviceType cannot be null!");
            this.serviceEndpointId = EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceEndpointId"), "serviceEndpointId cannot be null!");
            this.serviceEndpointUrl = EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceEndpointUrl"), "serviceEndpointUrl cannot be null!");
            this.serviceEndpointCapability = EMIRPublisher.extractStringIntoArray(EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceEndpointCapability"), "serviceEndpointCapability cannot be null!"));
            this.serviceEndpointTechnology = EMIRPublisher.extractStringIntoArray(EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceEndpointTechnology"), "serviceEndpointTechnology cannot be null!"));
            this.serviceEndpointInterfaceName = EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceEndpointInterfaceName"), "serviceEndpointInterfaceName cannot be null!");
            this.serviceEndpointInterfaceVersion = EMIRPublisher.isNotNull(EMIRPublisher.getStringConfigurationValue(serverConfiguration, "serviceEndpointInterfaceVersion"), "serviceEndpointInterfaceVersion cannot be null!");
            this.serviceRecordTtl = EMIRPublisher.isGreaterThan(0L, EMIRPublisher.getLongConfigurationValue(serverConfiguration, "serviceRecordTtl"), "serviceRecordTtl must be more than zero");
            publishInterval = EMIRPublisher.isGreaterThan(0L, EMIRPublisher.getLongConfigurationValue(serverConfiguration, "serviceRecordPublishInterval"), "serviceRecordPublishInterval must be more than zero");
            String keyPass = EMIRPublisher.getStringConfigurationValue(serverConfiguration, "keyPass");
            String certFile = EMIRPublisher.getStringConfigurationValue(serverConfiguration, "certFile");
            String keyFile = EMIRPublisher.getStringConfigurationValue(serverConfiguration, "keyFile");
            HttpClientBuilder httpBuilder = new HttpClientBuilder(this.emirUrl, certFile, keyFile, keyPass);
            this.httpClient = httpBuilder.buildClient();
        }
        catch (Exception e) {
            log.debug("Could not initialize EMIR publisher", (Throwable)e);
            configured = false;
        }
        if (configured) {
            timer.schedule((TimerTask)new RegistryPublishingTask(), 0L, publishInterval * 60L * 1000L);
            log.info("EMIR publisher configured to publish the service information every {} minutes", (Object)publishInterval);
        } else {
            log.info("EMIR publisher was not properly configured, information won't be published!");
        }
    }

    protected static String isNotNull(String object, String message) throws PseudoServerException {
        if (object == null) {
            throw new PseudoServerException(message);
        }
        return object;
    }

    protected static long isGreaterThan(long treshold, long value, String message) throws PseudoServerException {
        if (value <= treshold) {
            throw new PseudoServerException(message);
        }
        return value;
    }

    protected static String getStringConfigurationValue(PseudoServerConfiguration serverConfiguration, String key) throws PseudoServerException {
        return serverConfiguration.get(CFG_SECTION_EMIR, key);
    }

    protected static long getLongConfigurationValue(PseudoServerConfiguration serverConfiguration, String key) throws PseudoServerException {
        String value = serverConfiguration.get(CFG_SECTION_EMIR, key);
        return new Long(value);
    }

    protected static String[] extractStringIntoArray(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, ARRAY_DELIMITER);
        String[] array = new String[tokenizer.countTokens()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = tokenizer.nextToken();
        }
        return array;
    }

    protected HttpRequestBase getHttpUriRequest(boolean initial, HttpEntity httpEntity) {
        Object httpRequest = initial ? new HttpPost(this.emirUrl) : new HttpPut(this.emirUrl);
        httpRequest.setEntity(httpEntity);
        return (HttpRequestBase)httpRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish(boolean initial) {
        ByteArrayEntity httpEntity = this.generateHttpEntity();
        HttpRequestBase httpRequest = this.getHttpUriRequest(initial, (HttpEntity)httpEntity);
        HttpResponse httpResponse = null;
        try {
            log.info("Sending the request to the EMIR service with {} method", (Object)httpRequest.getMethod());
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            log.debug("The response code from the EMIR service: {}", (Object)statusCode);
            if (statusCode != 200) {
                log.warn("Invalid status code {} from the EMIR service!", (Object)statusCode);
            }
            if (log.isDebugEnabled()) {
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)httpResponse.getEntity().getContent(), (Writer)writer, (String)"UTF-8");
                log.debug("Response from the EMIR service: {}", (Object)writer.toString());
            }
        }
        catch (IOException e) {
            log.error("IO error while sending the request to the EMIR service.", (Throwable)e);
        }
        finally {
            httpRequest.releaseConnection();
            EntityUtils.consumeQuietly((HttpEntity)httpEntity);
        }
    }

    protected ByteArrayEntity generateHttpEntity() {
        String json = "{ ";
        json = json + "\"Service_ID\" : \"" + this.serviceId + "\",";
        json = json + "\"Service_Name\" : \"" + this.serviceName + "\",";
        json = json + "\"Service_Type\" : \"" + this.serviceType + "\",";
        json = json + "\"Service_Endpoint_ID\" : \"" + this.serviceEndpointId + "\",";
        json = json + "\"Service_Endpoint_URL\" : \"" + this.serviceEndpointUrl + "\",";
        json = json + "\"Service_Endpoint_Capability\" : [ " + EMIRPublisher.getJsonArray(this.serviceEndpointCapability) + " ],";
        json = json + "\"Service_Endpoint_Technology\" : [ " + EMIRPublisher.getJsonArray(this.serviceEndpointTechnology) + " ],";
        json = json + "\"Service_Endpoint_InterfaceName\" : \"" + this.serviceEndpointInterfaceName + "\",";
        json = json + "\"Service_Endpoint_InterfaceVersion\" : \"" + this.serviceEndpointInterfaceVersion + "\",";
        json = json + "\"Service_ExpireOn\" : " + EMIRPublisher.getJsonDate(new DateTime(DateTimeZone.UTC).plusMinutes((int)this.serviceRecordTtl));
        json = json + " }";
        log.debug("Final JSON message: {}", (Object)json);
        return new ByteArrayEntity(json.getBytes());
    }

    protected static String getJsonArray(String[] array) {
        String json = "";
        for (int i = 0; i < array.length - 1; ++i) {
            json = json + "\"" + array[i] + "\",";
        }
        json = json + "\"" + array[array.length - 1] + "\"";
        return json;
    }

    protected static String getJsonDate(DateTime date) {
        return "{ \"$date\" : \"" + ISODateTimeFormat.dateTime().print((ReadableInstant)date) + "\" }";
    }

    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
    }

    public void shutdown() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    class RegistryPublishingTask
    extends TimerTask {
        private boolean initial = true;

        RegistryPublishingTask() {
        }

        public void run() {
            log.debug("Publishing the information to the EMIR service...");
            EMIRPublisher.this.publish(this.initial);
            this.initial = false;
        }
    }
}

