/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.session.impl;

import java.util.Date;
import java.util.List;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.session.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements Session {
    private String token;
    private String dn;
    private Date expirationTime;
    private List<Attribute> attributes;

    public SessionImpl(String dn, String token, long lifetime) {
        this.dn = dn;
        this.token = token;
        Date now = new Date();
        this.expirationTime = new Date(now.getTime() + lifetime);
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    @Override
    public boolean isValid() {
        Date now = new Date();
        return now.before(this.expirationTime);
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }
}

