/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.auditor.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.auditor.AuditEventEntry;
import org.glite.pseudo.server.auditor.AuditPersonEntry;
import org.glite.pseudo.server.auditor.Auditor;
import org.glite.pseudo.server.auditor.AuditorException;
import org.glite.pseudo.server.auditor.event.AuditEvent;
import org.glite.pseudo.server.auditor.impl.AbstractHibernateAuditor;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateAuditor
extends AbstractHibernateAuditor
implements Auditor {
    private static final Logger log = LoggerFactory.getLogger(HibernateAuditor.class);

    public void logEvent(AuditEvent event) throws AuditorException {
        Map<String, String> attributesMap = event.getAttributesMap();
        String subjectDN = attributesMap.get("UserSubjectDN");
        String remoteAddress = attributesMap.get("RemoteAddress");
        Session session = this.getCurrentSession();
        Transaction tx = null;
        try {
            tx = session.beginTransaction();
            Query hqlQuery = session.createQuery("from " + this.personImpl + " as person where person.identifier like :subjectDN");
            hqlQuery.setString("subjectDN", subjectDN);
            AuditPersonEntry person = (AuditPersonEntry)hqlQuery.uniqueResult();
            if (person == null) {
                log.info("New user: {}", (Object)subjectDN);
                try {
                    person = this.makePersonEntry(subjectDN);
                }
                catch (Exception e) {
                    log.error("Error while constructing a new " + this.personImpl, (Throwable)e);
                    throw e;
                }
                session.save((Object)person);
                log.debug("New user saved.");
            } else {
                log.debug("Existing user: {}", (Object)subjectDN);
            }
            AuditEventEntry eventEntry = null;
            try {
                eventEntry = this.makeEventEntry(event, remoteAddress, person);
            }
            catch (Exception e) {
                log.error("Error while constructing a new {}", (Object)this.eventImpl, (Object)e);
                throw e;
            }
            person.addAuditEvent(eventEntry);
            session.save((Object)eventEntry);
            session.save((Object)person);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new AuditorException(e);
        }
        finally {
            HibernateAuditor.closeSession(session);
        }
    }

    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
        log.debug("Initializing HibernateAuditor..");
        super.init(configuration);
        log.info("HibernateAuditor successfully initialized.");
    }

    private AuditEventEntry makeEventEntry(AuditEvent event, String remoteAddress, AuditPersonEntry person) throws Exception {
        Constructor<?> constructor = Class.forName(this.eventImpl).getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        Class[] argClass = new Class[1];
        Object[] argObject = new Object[1];
        Array.set(argClass, 0, Date.class);
        Array.set(argObject, 0, Calendar.getInstance().getTime());
        obj.getClass().getMethod("setEventDate", argClass).invoke(obj, argObject);
        Array.set(argClass, 0, Integer.TYPE);
        Array.set(argObject, 0, new Integer(event.getLevel()));
        obj.getClass().getMethod("setEventLevel", argClass).invoke(obj, argObject);
        Array.set(argClass, 0, String.class);
        Array.set(argObject, 0, event.getMessage());
        obj.getClass().getMethod("setEventMessage", argClass).invoke(obj, argObject);
        Array.set(argClass, 0, Integer.TYPE);
        Array.set(argObject, 0, new Integer(event.getType()));
        obj.getClass().getMethod("setEventType", argClass).invoke(obj, argObject);
        Array.set(argClass, 0, String.class);
        Array.set(argObject, 0, remoteAddress);
        obj.getClass().getMethod("setRemoteAddress", argClass).invoke(obj, argObject);
        Array.set(argClass, 0, AuditPersonEntry.class);
        Array.set(argObject, 0, person);
        obj.getClass().getMethod("setEventAuthor", argClass).invoke(obj, argObject);
        return (AuditEventEntry)obj;
    }

    private AuditPersonEntry makePersonEntry(String subjectDN) throws Exception {
        Class[] classes = new Class[]{subjectDN.getClass()};
        Object[] initargs = new Object[]{subjectDN};
        Constructor<?> constructor = Class.forName(this.personImpl).getConstructor(new Class[0]);
        Object obj = constructor.newInstance(new Object[0]);
        Method method = obj.getClass().getMethod("setIdentifier", classes);
        method.invoke(obj, initargs);
        return (AuditPersonEntry)obj;
    }
}

