/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.attribute;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.glite.pseudo.common.util.Util;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.attribute.AttributeDefinition;
import org.glite.pseudo.server.attribute.AttributeDefinitionComparator;
import org.glite.pseudo.server.attribute.AttributeDefinitionException;
import org.glite.pseudo.server.attribute.AttributeDefinitions;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDefinitionsImpl
implements AttributeDefinitions {
    public static final String CONFIG_FILE_IDENTIFIER = "ConfigFile";
    private static Logger log = LoggerFactory.getLogger(AttributeDefinitionsImpl.class);
    private Map<String, AttributeDefinition> attributeDefinitions_ = null;
    private List<String> requiredAttributeNames_ = null;
    private Map<String, String> headerNameMapping_ = null;
    private FileConfiguration configuration_ = null;

    private void parseAttributeDefinitions() throws AttributeDefinitionException {
        this.attributeDefinitions_ = new HashMap<String, AttributeDefinition>();
        this.headerNameMapping_ = new HashMap<String, String>();
        this.requiredAttributeNames_ = new ArrayList<String>();
        List<String> attributeDefinitionNames = this.getList("AttributeDefinition[@name]");
        int nAttributeDefinitions = attributeDefinitionNames.size();
        for (int i = 0; i < nAttributeDefinitions; ++i) {
            String name = attributeDefinitionNames.get(i);
            String prefix = "AttributeDefinition(" + i + ")";
            String header = this.getString(prefix + "[@header]");
            String displayName = this.getString(prefix + "[@displayName]");
            String required = this.getString(prefix + "[@required]", false);
            String caseSensitive = this.getString(prefix + "[@caseSensitive]", false);
            this.headerNameMapping_.put(header, name);
            AttributeDefinition attributeDef = new AttributeDefinition(name, header, displayName);
            if (required != null && required.equalsIgnoreCase("true")) {
                this.requiredAttributeNames_.add(name);
                attributeDef.setRequired(true);
            }
            if (caseSensitive != null && caseSensitive.equalsIgnoreCase("false")) {
                attributeDef.setCaseSensitive(false);
            }
            this.attributeDefinitions_.put(name, attributeDef);
        }
        log.info("AttributeDefinitions=" + this.attributeDefinitions_);
        log.info("HeaderNameMapping=" + this.headerNameMapping_);
        log.info("RequiredAttributeNames=" + this.requiredAttributeNames_);
    }

    @Override
    public Attribute createAttribute(String name, String value) {
        Attribute attribute = new Attribute(name, value);
        AttributeDefinition attributeDefinition = this.attributeDefinitions_.get(name);
        if (attributeDefinition != null) {
            attribute.setDisplayName(attributeDefinition.getDisplayName());
            attribute.setCaseSensitive(attributeDefinition.isCaseSensitive());
            attribute.setRequired(attributeDefinition.isRequired());
        }
        return attribute;
    }

    @Override
    public List<Attribute> getUserAttributes(HttpServletRequest request) {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerValue;
            String headerName = (String)headers.nextElement();
            if (!this.headerNameMapping_.containsKey(headerName) || (headerValue = request.getHeader(headerName)) == null || headerValue.equals("")) continue;
            String decodedValue = "";
            try {
                decodedValue = Util.convertUTF8ToUnicode((String)headerValue);
            }
            catch (UnsupportedEncodingException e) {
                log.error("Error while encoding {} to Unicode", (Object)headerValue);
            }
            String[] attrValues = decodedValue.split(";");
            for (int i = 0; i < attrValues.length; ++i) {
                String attrName = this.getAttributeName(headerName);
                String attrValue = attrValues[i];
                attrValue = attrValue.trim();
                Attribute attribute = new Attribute(attrName, attrValue);
                AttributeDefinition attributeDefinition = this.attributeDefinitions_.get(attrName);
                if (attributeDefinition != null) {
                    attribute.setDisplayName(attributeDefinition.getDisplayName());
                    attribute.setCaseSensitive(attributeDefinition.isCaseSensitive());
                    attribute.setRequired(attributeDefinition.isRequired());
                }
                attributes.add(attribute);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("attributes=" + attributes);
        }
        return attributes;
    }

    @Override
    public List<AttributeDefinition> getAttributeDefinitions() {
        Collection<AttributeDefinition> definitions = this.attributeDefinitions_.values();
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>(definitions);
        Collections.sort(attributeDefinitions, new AttributeDefinitionComparator());
        return attributeDefinitions;
    }

    @Override
    public String getAttributeDisplayName(Attribute attribute) {
        String attrName = attribute.getName();
        if (this.attributeDefinitions_.containsKey(attrName)) {
            AttributeDefinition attrDef = this.attributeDefinitions_.get(attrName);
            return attrDef.getDisplayName();
        }
        return null;
    }

    private String getAttributeName(String header) {
        if (this.headerNameMapping_.containsKey(header)) {
            String name = this.headerNameMapping_.get(header);
            return name;
        }
        return null;
    }

    public boolean isAttributeRequired(Attribute attribute) {
        String attrName = attribute.getName();
        if (this.attributeDefinitions_.containsKey(attrName)) {
            AttributeDefinition attrDef = this.attributeDefinitions_.get(attrName);
            return attrDef.isRequired();
        }
        return AttributeDefinition.DEFAULT_REQUIRED;
    }

    public boolean isAttributeCaseSensitive(Attribute attribute) {
        String attrName = attribute.getName();
        if (this.attributeDefinitions_.containsKey(attrName)) {
            AttributeDefinition attrDef = this.attributeDefinitions_.get(attrName);
            return attrDef.isCaseSensitive();
        }
        return AttributeDefinition.DEFAULT_CASE_SENSITIVE;
    }

    @Override
    public void setDisplayNames(List<Attribute> attributes) {
        for (Attribute attr : attributes) {
            String displayName = this.getAttributeDisplayName(attr);
            attr.setDisplayName(displayName);
        }
    }

    @Override
    public List<String> getRequiredAttributeNames() {
        return this.requiredAttributeNames_;
    }

    protected FileConfiguration loadConfiguration(String filename) throws AttributeDefinitionException {
        XMLConfiguration config = null;
        try {
            log.info("XMLConfiguration file=" + filename);
            config = new XMLConfiguration(filename);
            if (log.isDebugEnabled()) {
                File configFile = config.getFile();
                log.debug("XMLConfiguration file=" + configFile.getAbsolutePath());
            }
        }
        catch (ConfigurationException e) {
            log.error("Failed to create XMLConfiguration: " + filename, (Throwable)e);
            throw new AttributeDefinitionException("Failed to create XMLConfiguration: " + filename, (Exception)((Object)e));
        }
        return config;
    }

    protected void setFileConfiguration(FileConfiguration configuration) throws AttributeDefinitionException {
        this.configuration_ = configuration;
    }

    public List<String> getList(String name) {
        List list = this.configuration_.getList(name);
        return list;
    }

    public String getString(String name) throws AttributeDefinitionException {
        return this.getString(name, true);
    }

    public String getString(String name, boolean throwException) throws AttributeDefinitionException {
        String value = this.configuration_.getString(name);
        if (value == null || value.equals("")) {
            value = null;
            if (throwException) {
                throw new AttributeDefinitionException(name + " is null or empty: " + this.getFilename());
            }
        }
        return value;
    }

    protected String getFilename() {
        return this.configuration_.getFile().getAbsolutePath();
    }

    @Override
    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
        Profile.Section cfgSection = configuration.getAttributeDefinitionsConfiguration();
        String filename = Util.safeTrimOrNullString((String)((String)cfgSection.get((Object)CONFIG_FILE_IDENTIFIER)));
        if (filename == null) {
            throw new PseudoServerException("Attribute definition configuration file cannot be empty!");
        }
        log.debug("filename: {}", (Object)filename);
        try {
            FileConfiguration fileConfiguration = this.loadConfiguration(filename);
            this.setFileConfiguration(fileConfiguration);
            this.parseAttributeDefinitions();
        }
        catch (AttributeDefinitionException e) {
            throw new PseudoServerException("Could not parse the attribute definition configuration!", e);
        }
    }

    @Override
    public void shutdown() {
    }
}

