/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import org.apache.commons.lang.builder.ToStringBuilder;

public class VOMSServerInfo {
    String hostName;
    int port;
    String hostDn;
    String voName;
    String globusVersion;
    String alias;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getHostDn() {
        return this.hostDn;
    }

    public void setHostDn(String hostDn) {
        this.hostDn = hostDn;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostname) {
        this.hostName = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getVoName() {
        return this.voName;
    }

    public void setVoName(String voName) {
        this.voName = voName;
    }

    public int getGlobusVersionAsInt() {
        if (this.globusVersion == null) {
            return -1;
        }
        return Integer.parseInt(this.globusVersion) / 10;
    }

    public String getGlobusVersion() {
        return this.globusVersion;
    }

    public void setGlobusVersion(String globusVersion) {
        this.globusVersion = globusVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VOMSServerInfo)) {
            return false;
        }
        VOMSServerInfo other = (VOMSServerInfo)obj;
        if (other.getHostName() != null && this.hostName.equals(other.getHostName())) {
            return this.getPort() == other.getPort();
        }
        return false;
    }

    public int hashCode() {
        int result = 14;
        result = 29 * result + this.hostName.hashCode();
        return 29 * result + this.port;
    }

    public static VOMSServerInfo fromStringArray(String[] tokens) {
        VOMSServerInfo info = new VOMSServerInfo();
        info.setVoName(tokens[4]);
        info.setHostName(tokens[1]);
        info.setPort(Integer.parseInt(tokens[2]));
        info.setHostDn(tokens[3]);
        info.setAlias(tokens[0]);
        if (tokens.length == 6) {
            info.setGlobusVersion(tokens[5]);
        }
        return info;
    }

    public String compactString() {
        return "[vo=" + this.voName + ",host=" + this.hostName + ",port=" + this.port + ",hostDN=" + this.hostDn + ",globusVersion=" + this.globusVersion + "]";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

