/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.PKIVerifier;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.contact.GSIVerifier;
import org.glite.voms.contact.UserCredentials;
import org.glite.voms.contact.VOMSESFileParser;
import org.glite.voms.contact.VOMSErrorMessage;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSParser;
import org.glite.voms.contact.VOMSProtocol;
import org.glite.voms.contact.VOMSProxyBuilder;
import org.glite.voms.contact.VOMSRequestFactory;
import org.glite.voms.contact.VOMSRequestOptions;
import org.glite.voms.contact.VOMSResponse;
import org.glite.voms.contact.VOMSServerInfo;
import org.glite.voms.contact.VOMSServerMap;
import org.glite.voms.contact.VOMSSocket;
import org.glite.voms.contact.VOMSWarningMessage;

public class VOMSProxyInit {
    private static final Logger log = Logger.getLogger(VOMSProxyInit.class);
    private static VOMSProxyInit instance;
    private VOMSServerMap serverMap;
    private UserCredentials userCredentials;
    private VOMSProtocol protocol = VOMSProtocol.instance();
    private String proxyOutputFile = File.separator + "tmp" + File.separator + "x509up_u_" + System.getProperty("user.name");
    private int proxyLifetime = 86400;
    private int proxyType = 2;
    private int delegationType = 0;
    private String policyType = null;
    private int bits = 1024;
    private VOMSWarningMessage[] warnings = null;

    public VOMSProxyInit(String privateKeyPassword) {
        try {
            this.serverMap = VOMSESFileParser.instance().buildServerMap();
            this.userCredentials = UserCredentials.instance(privateKeyPassword);
        }
        catch (IOException e) {
            log.error((Object)("Error parsing vomses files: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
    }

    private VOMSProxyInit(UserCredentials credentials) {
        if (credentials == null) {
            throw new VOMSException("Unable to find GlobusCredentials!");
        }
        this.userCredentials = credentials;
        try {
            this.serverMap = VOMSESFileParser.instance().buildServerMap();
        }
        catch (IOException e) {
            log.error((Object)("Error parsing vomses files: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
    }

    public static VOMSProxyInit instance(String privateKeyPassword) {
        return new VOMSProxyInit(privateKeyPassword);
    }

    public static VOMSProxyInit instance() {
        return new VOMSProxyInit((String)null);
    }

    public static VOMSProxyInit instance(UserCredentials credentials) {
        return new VOMSProxyInit(credentials);
    }

    public void addVomsServer(VOMSServerInfo info) {
        this.serverMap.add(info);
    }

    public synchronized AttributeCertificate getVomsAC(VOMSRequestOptions requestOptions) {
        this.warnings = null;
        if (requestOptions.getVoName() == null) {
            throw new VOMSException("Please specify a vo name to create a voms ac.");
        }
        Set servers = this.serverMap.get(requestOptions.getVoName());
        if (servers == null) {
            throw new VOMSException("Unknown VO '" + requestOptions.getVoName() + "'. Check the VO name or your vomses configuration files.");
        }
        Iterator serverIter = servers.iterator();
        while (serverIter.hasNext()) {
            VOMSServerInfo serverInfo = (VOMSServerInfo)serverIter.next();
            try {
                VOMSResponse response = this.contactServer(serverInfo, requestOptions);
                if (!response.hasErrors()) {
                    log.debug((Object)"No errors");
                    if (response.hasWarnings()) {
                        this.logAndSetWarningMessages(response);
                    }
                    AttributeCertificate ac = VOMSProxyBuilder.buildAC(response.getAC());
                    log.info((Object)("Got AC from VOMS server " + serverInfo.compactString()));
                    if (log.isDebugEnabled()) {
                        try {
                            log.debug((Object)("AC validity period:\nNotBefore:" + ac.getNotBefore() + "\nNotAfter:" + ac.getNotAfter()));
                        }
                        catch (ParseException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                            e.printStackTrace();
                        }
                    }
                    return ac;
                }
                log.error((Object)("Got error response from VOMS server " + serverInfo.compactString()));
                this.logErrorMessages(response);
            }
            catch (VOMSException e) {
                log.error((Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (serverIter.hasNext()) continue;
                throw e;
            }
        }
        return null;
    }

    public synchronized String getVomsData(VOMSRequestOptions requestOptions) {
        this.warnings = null;
        if (requestOptions.getVoName() == null) {
            throw new VOMSException("Please specify a vo name to create a voms ac.");
        }
        Set servers = this.serverMap.get(requestOptions.getVoName());
        if (servers == null) {
            throw new VOMSException("Unknown VO '" + requestOptions.getVoName() + "'. Check the VO name or your vomses configuration files.");
        }
        Iterator serverIter = servers.iterator();
        while (serverIter.hasNext()) {
            VOMSServerInfo serverInfo = (VOMSServerInfo)serverIter.next();
            try {
                VOMSResponse response = this.contactServer(serverInfo, requestOptions);
                if (!response.hasErrors()) {
                    byte[] data;
                    if (response.hasWarnings()) {
                        this.logAndSetWarningMessages(response);
                    }
                    if ((data = response.getData()) != null) {
                        log.info((Object)("Got Data from VOMS server " + Arrays.toString(data)));
                        return new String(data);
                    }
                    if (requestOptions.isRequestList()) {
                        AttributeCertificate ac = VOMSProxyBuilder.buildAC(response.getAC());
                        if (ac != null) {
                            List fqans = ac.getFullyQualifiedAttributes();
                            StringBuilder result = new StringBuilder();
                            if (fqans != null) {
                                for (int i = 0; i < fqans.size(); ++i) {
                                    result.append((String)fqans.get(i));
                                    result.append("\n");
                                }
                            }
                            return result.toString();
                        }
                        return null;
                    }
                    return null;
                }
                log.error((Object)("Got error response from VOMS server " + serverInfo.compactString()));
                this.logErrorMessages(response);
            }
            catch (VOMSException e) {
                log.error((Object)e.getMessage());
                if (log.isDebugEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                if (serverIter.hasNext()) continue;
                throw e;
            }
        }
        return null;
    }

    public void validateACs(List ACs) {
        PKIVerifier verifier;
        if (ACs.isEmpty()) {
            throw new VOMSException("Cannot validate an empty list of Attribute Certificates!");
        }
        log.debug((Object)("AC Validation started at: " + new Date()));
        try {
            verifier = new PKIVerifier();
        }
        catch (Exception e) {
            log.error((Object)("Error instantiating PKIVerifier: " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error instantiating PKIVerifier: " + e.getMessage(), e);
        }
        Iterator i = ACs.iterator();
        while (i.hasNext()) {
            AttributeCertificate ac = (AttributeCertificate)i.next();
            if (verifier.verify(ac)) continue;
            i.remove();
        }
        log.debug((Object)("AC Validation ended at: " + new Date()));
    }

    public synchronized UserCredentials getVomsProxy() {
        return this.getVomsProxy(null);
    }

    protected UserCredentials getGridProxy() {
        UserCredentials proxy = VOMSProxyBuilder.buildProxy(this.userCredentials, this.proxyLifetime, this.proxyType, this.bits);
        this.warnings = null;
        try {
            this.saveProxy(proxy);
            return proxy;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error saving proxy to file " + this.proxyOutputFile + ":" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error saving proxy to file " + this.proxyOutputFile + ":" + e.getMessage(), e);
        }
    }

    public synchronized UserCredentials getVomsProxy(Collection listOfReqOptions) {
        if (listOfReqOptions == null) {
            return this.getGridProxy();
        }
        if (listOfReqOptions.isEmpty()) {
            throw new VOMSException("No request options specified!");
        }
        Iterator i = listOfReqOptions.iterator();
        ArrayList<AttributeCertificate> ACs = new ArrayList<AttributeCertificate>();
        this.warnings = null;
        while (i.hasNext()) {
            VOMSRequestOptions options = (VOMSRequestOptions)i.next();
            if (options.getVoName() == null) {
                throw new VOMSException("Please specify a vo name to create a voms proxy.");
            }
            AttributeCertificate ac = this.getVomsAC(options);
            ACs.add(ac);
        }
        this.validateACs(ACs);
        if (ACs.isEmpty()) {
            throw new VOMSException("AC validation failed!");
        }
        log.info((Object)"ACs validation succeded.");
        UserCredentials proxy = VOMSProxyBuilder.buildProxy(this.userCredentials, ACs, this.proxyLifetime, this.proxyType, this.delegationType, this.policyType, this.bits);
        try {
            this.saveProxy(proxy);
            return proxy;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("Error saving proxy to file " + this.proxyOutputFile + ":" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error saving proxy to file " + this.proxyOutputFile + ":" + e.getMessage(), e);
        }
    }

    private void saveProxy(UserCredentials credential) throws FileNotFoundException {
        if (this.proxyOutputFile != null) {
            VOMSProxyBuilder.saveProxy(credential, this.proxyOutputFile);
            log.info((Object)("Proxy saved in :" + this.proxyOutputFile));
        }
    }

    private void logErrorMessages(VOMSResponse response) {
        VOMSErrorMessage[] msgs = response.errorMessages();
        for (int i = 0; i < msgs.length; ++i) {
            log.error((Object)msgs[i]);
        }
    }

    private void logAndSetWarningMessages(VOMSResponse response) {
        VOMSWarningMessage[] msgs = response.warningMessages();
        this.setWarnings(msgs);
        for (int i = 0; i < msgs.length; ++i) {
            log.warn((Object)msgs[i]);
        }
    }

    private void setWarnings(VOMSWarningMessage[] msgs) {
        this.warnings = msgs;
    }

    public boolean hasWarnings() {
        return this.warnings != null;
    }

    public VOMSWarningMessage[] getWarnings() {
        return this.warnings;
    }

    private VOMSResponse contactServerREST(VOMSServerInfo sInfo, VOMSRequestOptions reqOptions) {
        String url = "https://" + sInfo.getHostName() + ":" + sInfo.getPort() + VOMSRequestFactory.instance().buildRESTRequest(reqOptions);
        VOMSResponse resp = null;
        log.debug((Object)("Final URL is: " + url));
        int gridProxyType = sInfo.getGlobusVersionAsInt();
        VOMSSocket socket = gridProxyType > 0 ? VOMSSocket.instance(this.userCredentials, sInfo.getHostDn(), gridProxyType) : VOMSSocket.instance(this.userCredentials, sInfo.getHostDn());
        HttpsURLConnection conn = null;
        try {
            SSLSocketFactory factory = socket.getFactory();
            URL vomsUrl = new URL(url);
            conn = (HttpsURLConnection)vomsUrl.openConnection();
            conn.setSSLSocketFactory(factory);
            HostnameVerifier v = conn.getDefaultHostnameVerifier();
            conn.setHostnameVerifier(new GSIVerifier(v, sInfo.getHostDn()));
            conn.connect();
            Object o = conn.getContent();
            resp = VOMSParser.instance().parseResponse((InputStream)o);
        }
        catch (Exception e) {
            log.error((Object)("Error connecting to " + sInfo.compactString() + ":" + e.getMessage()));
            try {
                log.error((Object)("Error code is: " + conn.getResponseCode()));
                InputStream is = conn.getErrorStream();
                resp = VOMSParser.instance().parseResponse(is);
                return resp;
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                throw new VOMSException("Error connecting to " + sInfo.compactString() + ":" + ex.getMessage(), ex);
            }
        }
        return resp;
    }

    protected VOMSResponse contactServer(VOMSServerInfo sInfo, VOMSRequestOptions reqOptions) {
        VOMSResponse response;
        log.info((Object)("Contacting server " + sInfo.compactString()));
        VOMSResponse resp = this.contactServerREST(sInfo, reqOptions);
        if (resp != null) {
            return resp;
        }
        int gridProxyType = sInfo.getGlobusVersionAsInt();
        VOMSSocket socket = gridProxyType > 0 ? VOMSSocket.instance(this.userCredentials, sInfo.getHostDn(), gridProxyType) : VOMSSocket.instance(this.userCredentials, sInfo.getHostDn());
        try {
            socket.connect(sInfo.getHostName(), sInfo.getPort());
        }
        catch (Exception e) {
            log.error((Object)("Error connecting to " + sInfo.compactString() + ":" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error connecting to " + sInfo.compactString() + ":" + e.getMessage(), e);
        }
        try {
            reqOptions.setVoName(sInfo.getVoName());
            this.protocol.sendRequest(reqOptions, socket.getOutputStream());
            response = this.protocol.getResponse(socket.getInputStream());
            socket.close();
        }
        catch (IOException e) {
            log.error((Object)("Error communicating with server " + sInfo.getHostName() + ":" + sInfo.getPort() + ":" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error communicating with server " + sInfo.getHostName() + ":" + sInfo.getPort() + ":" + e.getMessage(), e);
        }
        return response;
    }

    public String getProxyOutputFile() {
        return this.proxyOutputFile;
    }

    public void setProxyOutputFile(String proxyOutputFile) {
        this.proxyOutputFile = proxyOutputFile;
    }

    public int getProxyLifetime() {
        return this.proxyLifetime;
    }

    public void setProxyLifetime(int proxyLifetime) {
        this.proxyLifetime = proxyLifetime;
    }

    public int getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(int proxyType) {
        this.proxyType = proxyType;
    }

    public int getProxyKeySize() {
        return this.bits;
    }

    public void setProxyKeySize(int bits) {
        this.bits = bits;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String policyType) {
        this.policyType = policyType;
    }

    public int getDelegationType() {
        return this.delegationType;
    }

    public void setDelegationType(int delegationType) {
        this.delegationType = delegationType;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

