/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSParser;
import org.glite.voms.contact.VOMSRequestFactory;
import org.glite.voms.contact.VOMSRequestOptions;
import org.glite.voms.contact.VOMSResponse;
import org.w3c.dom.Document;

public class VOMSProtocol {
    private static final Logger log = Logger.getLogger(VOMSProtocol.class);
    private VOMSRequestFactory requestFactory = VOMSRequestFactory.instance();
    private TransformerFactory transformerFactory;
    private VOMSParser parser = VOMSParser.instance();

    private VOMSProtocol() {
        this.transformerFactory = TransformerFactory.newInstance();
    }

    public static VOMSProtocol instance() {
        return new VOMSProtocol();
    }

    protected String xmlDocAsString(Document doc) {
        Transformer transformer;
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)("Error creating XML transformer:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error creating XML transformer:", e);
        }
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult res = new StreamResult(writer);
        try {
            transformer.transform(source, res);
        }
        catch (TransformerException e) {
            log.error((Object)("Error caught serializing XML :" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error caugh serializing XML :", e);
        }
        writer.flush();
        return writer.toString();
    }

    public void sendRequest(VOMSRequestOptions requestOptions, OutputStream stream) {
        Transformer transformer;
        Document request = this.requestFactory.buildRequest(requestOptions);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Voms request:\n" + this.xmlDocAsString(request)));
        }
        try {
            transformer = this.transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)("Error creating XML transformer:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("Error creating XML transformer:", e);
        }
        DOMSource source = new DOMSource(request);
        StreamResult res = new StreamResult(stream);
        try {
            transformer.transform(source, res);
            stream.flush();
        }
        catch (TransformerException e) {
            log.error((Object)("XML request serialization error! " + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("XML request serialization error! " + e.getMessage(), e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException("XML request serialization error! " + e.getMessage(), e);
        }
    }

    public VOMSResponse getResponse(InputStream stream) {
        return this.parser.parseResponse(stream);
    }
}

