/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.X509Principal;
import org.glite.voms.PKIUtils;
import org.glite.voms.ac.ACCerts;
import org.glite.voms.ac.ACTargets;
import org.glite.voms.ac.AttributeCertificateInfo;
import org.glite.voms.ac.FullAttributes;
import org.glite.voms.ac.Holder;
import org.glite.voms.ac.Util;

public class AttributeCertificate
implements DEREncodable {
    protected static final Logger logger = Logger.getLogger(AttributeCertificate.class);
    AttributeCertificateInfo acInfo;
    AlgorithmIdentifier signatureAlgorithm;
    DERBitString signatureValue;
    DERObject signedObj = null;

    public AttributeCertificate(ASN1Sequence seq) throws IOException {
        this.signedObj = ((ASN1Sequence)seq.getObjectAt(0)).getDERObject();
        this.acInfo = new AttributeCertificateInfo((ASN1Sequence)seq.getObjectAt(0));
        this.signatureAlgorithm = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(1));
        this.signatureValue = (DERBitString)seq.getObjectAt(2);
    }

    public static AttributeCertificate getInstance(InputStream in) throws IOException {
        logger.debug((Object)("called with in = " + in));
        ASN1InputStream dIn = new ASN1InputStream(in);
        logger.debug((Object)"created");
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        return new AttributeCertificate(seq);
    }

    public AttributeCertificateInfo getAcinfo() {
        return this.acInfo;
    }

    public ASN1Sequence getAttributes() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getAttributes();
    }

    public DERInteger getSerialNumber() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getSerialNumber();
    }

    public String getVO() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getVO();
    }

    public String getHostPort() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getHostPort();
    }

    public String getHost() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getHost();
    }

    public int getPort() {
        if (this.acInfo == null) {
            return -1;
        }
        return this.acInfo.getPort();
    }

    public FullAttributes getFullAttributes() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getFullAttributes();
    }

    public ACCerts getCertList() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getCertList();
    }

    public ACTargets getTargets() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getTargets();
    }

    public List getFullyQualifiedAttributes() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getFullyQualifiedAttributes();
    }

    public List getListOfFQAN() {
        if (this.acInfo == null) {
            return null;
        }
        return this.acInfo.getListOfFQAN();
    }

    public List getAttributes(String oid) {
        if (oid == null) {
            return Collections.EMPTY_LIST;
        }
        ASN1Sequence seq = this.getAttributes();
        if (seq == null || seq.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        Vector v = new Vector();
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence attribute = (ASN1Sequence)e.nextElement();
            if (!oid.equals(((DERObjectIdentifier)attribute.getObjectAt(0)).getId())) continue;
            DERSet set = (DERSet)attribute.getObjectAt(1);
            Enumeration s = set.getObjects();
            while (s.hasMoreElements()) {
                v.add(s.nextElement());
            }
        }
        return v;
    }

    public X509Extensions getExtensions() {
        return this.acInfo == null ? null : this.acInfo.getExtensions();
    }

    public X509Principal getIssuerX509() {
        if (this.acInfo == null) {
            return null;
        }
        if (this.acInfo.getIssuer() == null) {
            return null;
        }
        ASN1Sequence seq = (ASN1Sequence)this.acInfo.getIssuer().getIssuerName().getDERObject();
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            GeneralName gn = GeneralName.getInstance(e.nextElement());
            if (gn.getTagNo() != 4) continue;
            return Util.generalNameToX509Name(gn);
        }
        return null;
    }

    public X500Principal getIssuer() {
        if (this.acInfo == null) {
            return null;
        }
        if (this.acInfo.getIssuer() == null) {
            return null;
        }
        ASN1Sequence seq = (ASN1Sequence)this.acInfo.getIssuer().getIssuerName().getDERObject();
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            GeneralName gn = GeneralName.getInstance(o);
            if (gn.getTagNo() != 4) continue;
            return Util.generalNameToX500Name(gn);
        }
        return null;
    }

    public String getHolderX509() {
        if (this.acInfo == null) {
            return null;
        }
        if (this.acInfo.getHolder() == null) {
            return null;
        }
        GeneralNames gns = this.acInfo.getHolder().getIssuer();
        Enumeration e = ((ASN1Sequence)gns.getDERObject()).getObjects();
        while (e.hasMoreElements()) {
            GeneralName gn = (GeneralName)e.nextElement();
            if (gn.getTagNo() != 4) continue;
            X509Principal principal = Util.generalNameToX509Name(gn);
            return PKIUtils.getOpenSSLFormatPrincipal((Principal)principal);
        }
        return null;
    }

    public Holder getHolder() {
        return this.acInfo == null ? null : this.acInfo.getHolder();
    }

    private static Date getDate(DERGeneralizedTime time) throws ParseException {
        SimpleDateFormat dateF;
        String t = time.getTime();
        if (t.indexOf("GMT") > 0) {
            dateF = new SimpleDateFormat("yyyyMMddHHmmssz");
        } else {
            dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        }
        return dateF.parse(time.getTime());
    }

    public Date getNotAfter() throws ParseException {
        return AttributeCertificate.getDate(this.acInfo.getAttrCertValidityPeriod().getNotAfterTime());
    }

    public Date getNotBefore() throws ParseException {
        return AttributeCertificate.getDate(this.acInfo.getAttrCertValidityPeriod().getNotBeforeTime());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DERBitString getSignatureValue() {
        return this.signatureValue;
    }

    public byte[] getSignature() {
        return this.signatureValue.getBytes();
    }

    public boolean validAt(Date date) {
        AttCertValidityPeriod validity = this.acInfo.getAttrCertValidityPeriod();
        if (date == null) {
            date = new Date();
        }
        try {
            Calendar notAfter = Calendar.getInstance();
            Calendar notBefore = Calendar.getInstance();
            notAfter.setTime(AttributeCertificate.getDate(validity.getNotAfterTime()));
            notBefore.setTime(AttributeCertificate.getDate(validity.getNotBeforeTime()));
            notAfter.add(12, 5);
            notBefore.add(12, -5);
            return notAfter.getTime().after(date) && notBefore.getTime().before(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid validity encoding in Attribute Certificate");
        }
    }

    public boolean isValid() {
        return this.validAt(new Date());
    }

    public boolean verify(PublicKey key) {
        Object error = null;
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)b).writeObject((Object)this.acInfo);
            Object data = null;
            Signature sig = Signature.getInstance(this.signatureAlgorithm.getObjectId().getId());
            sig.initVerify(key);
            sig.update(b.toByteArray());
            return sig.verify(this.signatureValue.getBytes());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error verifying signature of AC issued by " + this.getIssuer().getName() + " : " + e.getMessage()));
            }
            return false;
        }
    }

    public boolean verifyCert(X509Certificate cert) {
        Object error = null;
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            new DEROutputStream((OutputStream)b).writeObject((Object)this.acInfo);
            Signature sig = Signature.getInstance(this.signatureAlgorithm.getObjectId().getId());
            sig.initVerify(cert);
            sig.update(b.toByteArray());
            return sig.verify(this.signatureValue.getBytes());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error verifying signature of AC issued by " + this.getIssuer().getName() + " : " + e.getMessage()));
            }
            return false;
        }
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.acInfo);
        v.add((DEREncodable)this.signatureAlgorithm);
        v.add((DEREncodable)this.signatureValue);
        return new DERSequence((DEREncodableVector)v);
    }
}

