/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.glite.voms.BasicVOMSTrustStore;
import org.glite.voms.PKIVerifier;
import org.glite.voms.ac.ACTrustStore;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.VOMSTrustStore;

public class ACValidator {
    protected static final Logger log = Logger.getLogger(ACValidator.class);
    private static ACValidator theInstance = null;
    protected ACTrustStore myTrustStore;
    protected VOMSTrustStore myVOMSStore;
    protected PKIVerifier theVerifier;

    public ACValidator(ACTrustStore trustStore) {
        if (trustStore == null) {
            throw new IllegalArgumentException("ACValidator: constructor must have an ACTrustStore");
        }
        this.myTrustStore = trustStore;
    }

    public ACValidator(VOMSTrustStore theStore) {
        if (theStore == null) {
            throw new IllegalArgumentException("ACValidator: constructor must have a VOMSTrustStore");
        }
        this.myVOMSStore = theStore;
        try {
            this.theVerifier = new PKIVerifier(this.myVOMSStore);
        }
        catch (IOException e) {
            log.error((Object)("Problems while initializing the verifier: " + e.getMessage()));
            throw new IllegalArgumentException("Problems with the passed store: " + e.getMessage());
        }
        catch (CertificateException e) {
            log.error((Object)("Problems while initializing the verifier: " + e.getMessage()));
            throw new IllegalArgumentException("Problems with the passed store: " + e.getMessage());
        }
        catch (CRLException e) {
            log.error((Object)("Problems while initializing the verifier: " + e.getMessage()));
            throw new IllegalArgumentException("Problems with the passed store: " + e.getMessage());
        }
    }

    public ACValidator(PKIVerifier verifier) {
        this.myTrustStore = null;
        this.myVOMSStore = null;
        this.theVerifier = verifier;
    }

    public static ACValidator getInstance() {
        return ACValidator.getInstance((VOMSTrustStore)null);
    }

    public static ACValidator getInstance(ACTrustStore trustStore) throws IllegalArgumentException {
        theInstance = theInstance != null ? theInstance : new ACValidator(trustStore);
        return theInstance;
    }

    public static ACValidator getInstance(VOMSTrustStore trustStore) throws IllegalArgumentException {
        theInstance = theInstance != null ? theInstance : new ACValidator(trustStore);
        return theInstance;
    }

    public void cleanup() {
        if (this.myTrustStore != null && this.myTrustStore instanceof BasicVOMSTrustStore) {
            ((BasicVOMSTrustStore)this.myTrustStore).stopRefresh();
        }
        if (this.myVOMSStore != null) {
            this.myVOMSStore.stopRefresh();
        }
        if (this.theVerifier != null) {
            this.theVerifier.cleanup();
        }
    }

    public boolean validate(AttributeCertificate ac) {
        if (ac == null) {
            return false;
        }
        if (this.theVerifier != null) {
            return this.theVerifier.verify(ac);
        }
        if (!ac.isValid()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AC expired or not yet valid. Issuer : " + ac.getIssuer().getName()));
            }
            return false;
        }
        X509Certificate[] candidates = this.myTrustStore.getAACandidate(ac.getIssuer());
        if (candidates == null || candidates.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("AC not valid (no such trusted issuer) : " + ac.getIssuer().getName()));
            }
            return false;
        }
        for (int i = 0; i < candidates.length; ++i) {
            if (ac.verify(candidates[i].getPublicKey())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AC signature verified OK by issuer : " + candidates[i].getSubjectX500Principal().getName()));
                }
                return true;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("AC from signature did not verify OK by issuer : " + candidates[i].getSubjectX500Principal().getName()));
        }
        return false;
    }
}

