/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.LSCFile;
import org.glite.voms.Namespace;
import org.glite.voms.PKIUtils;
import org.glite.voms.SigningPolicy;
import org.glite.voms.ac.VOMSTrustStore;

public class PKIStore
implements VOMSTrustStore {
    public static final String TRUST_STORE_REFRESH_PERIOD_PROPERTY = "voms.trust-store-refresh-period";
    public static final int DEFAULT_TRUST_STORE_REFRESH_PERIOD = 10;
    private Hashtable certificates = null;
    private Hashtable crls = null;
    private Hashtable signings = null;
    private Hashtable lscfiles = null;
    private Hashtable vomscerts = null;
    private Hashtable namespaces = null;
    private int instances = 1;
    private static Logger logger = Logger.getLogger((String)PKIStore.class.getName());
    public static final int TYPE_VOMSDIR = 1;
    public static final int TYPE_CADIR = 2;
    private static final int CERT = 1;
    private static final int CRL = 2;
    private static final int SIGN = 3;
    private static final int LSC = 4;
    private static final int NAMESPACE = 5;
    private static final int HASHCAPACITY = 75;
    private boolean aggressive = false;
    private Timer theTimer = null;
    private String certDir = null;
    private int type = -1;
    public static final String DEFAULT_VOMSDIR = File.separator + "etc" + File.separator + "grid-security" + File.separator + "vomsdir";
    public static final String DEFAULT_CADIR = File.separator + "etc" + File.separator + "grid-security" + File.separator + "certificates";

    public synchronized Hashtable getCAs() {
        return (Hashtable)this.certificates.clone();
    }

    public synchronized Hashtable getCRLs() {
        return this.crls;
    }

    public synchronized Hashtable getSignings() {
        return this.signings;
    }

    public synchronized Hashtable getNamespaces() {
        return this.namespaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        PKIStore newReader = null;
        logger.info((Object)("Starting PKIStore refresh (type: " + this.type + ")"));
        try {
            newReader = new PKIStore(this.certDir, this.type, this.aggressive, false);
        }
        catch (Exception e) {
            logger.error((Object)("Cannot refresh store: " + e.getMessage()));
            return;
        }
        finally {
            if (newReader != null) {
                newReader.stopRefresh();
            }
        }
        try {
            this.certificates.clear();
            this.certificates = newReader.certificates;
            newReader.certificates = null;
            this.crls.clear();
            this.crls = newReader.crls;
            newReader.crls = null;
            this.signings.clear();
            this.signings = newReader.signings;
            newReader.signings = null;
            this.lscfiles.clear();
            this.lscfiles = newReader.lscfiles;
            newReader.lscfiles = null;
            this.vomscerts.clear();
            this.vomscerts = newReader.vomscerts;
            newReader.vomscerts = null;
            this.namespaces.clear();
            this.namespaces = newReader.namespaces;
            newReader.namespaces = null;
        }
        finally {
            newReader = null;
        }
    }

    PKIStore(String dir, int type, boolean aggressive, boolean timer) throws IOException, CertificateException, CRLException {
        int refreshPeriod;
        String vomsApiJavaRefreshPeriod;
        this.aggressive = aggressive;
        this.certificates = new Hashtable(75);
        this.crls = new Hashtable(75);
        this.signings = new Hashtable(75);
        this.lscfiles = new Hashtable(75);
        this.vomscerts = new Hashtable(75);
        this.namespaces = new Hashtable(75);
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Unsupported value for type parameter in PKIReader constructor");
        }
        if (dir == null || dir.equals("")) {
            if (type == 1) {
                dir = System.getProperty("VOMSDIR");
                if (dir == null) {
                    dir = DEFAULT_VOMSDIR;
                }
            } else if (type == 2 && (dir = System.getProperty("CADIR")) == null) {
                dir = DEFAULT_CADIR;
            }
        }
        logger.info((Object)("Initializing " + (type == 1 ? "VOMS" : "CA") + " certificate store from directory: " + dir));
        File theDir = new File(dir);
        if (!theDir.exists()) {
            if (type == 2) {
                StringBuilder message = new StringBuilder();
                message.append("Directory ");
                message.append(dir);
                message.append(" doesn't exist on this machine!");
                message.append(" Please specify a value for the cadir directory or set the CADIR system property.");
                throw new FileNotFoundException(message.toString());
            }
            logger.warn((Object)"Please specify a value for the vomsdir directory or set the VOMSDIR system property.");
        }
        if (theDir.exists() && !theDir.isDirectory()) {
            throw new IllegalArgumentException((type == 1 ? "Voms certificate" : "CA certificate") + " directory passed as argument is not a directory! [" + theDir.getAbsolutePath() + "]");
        }
        if (theDir.exists() && theDir.list().length == 0) {
            if (type == 2) {
                throw new IllegalArgumentException("CA certificate directory passed as argument is empty! [" + theDir.getAbsolutePath() + "]");
            }
            logger.warn((Object)("Voms certificate directory passed as argument is empty! [" + theDir.getAbsolutePath() + "]"));
            logger.warn((Object)"Validation of VOMS Attribute Certificate will likely fail.");
        }
        this.certDir = dir;
        this.type = type;
        if (theDir.exists()) {
            this.load();
        }
        if ((vomsApiJavaRefreshPeriod = System.getProperty(TRUST_STORE_REFRESH_PERIOD_PROPERTY)) == null) {
            refreshPeriod = 10;
        } else {
            try {
                refreshPeriod = Integer.parseInt(vomsApiJavaRefreshPeriod);
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)"Error parsing voms.trust-store-refresh-period! Using default value: 10 minutes");
                refreshPeriod = 10;
            }
        }
        if (timer) {
            this.theTimer = new Timer(true);
            this.theTimer.scheduleAtFixedRate((TimerTask)new Refreshener(), 30000L, TimeUnit.MINUTES.toMillis(refreshPeriod));
        }
        this.instances = 1;
    }

    public PKIStore(String dir, int type, boolean aggressive) throws IOException, CertificateException, CRLException {
        this(dir, type, aggressive, true);
    }

    public PKIStore(String dir, int type) throws IOException, CertificateException, CRLException {
        this(dir, type, true, true);
    }

    public PKIStore(int type) throws IOException, CertificateException, CRLException {
        this(null, type, true, true);
    }

    public PKIStore() {
        this.aggressive = true;
        this.certificates = new Hashtable(75);
        this.crls = new Hashtable(75);
        this.signings = new Hashtable(75);
        this.lscfiles = new Hashtable(75);
        this.vomscerts = new Hashtable(75);
        this.namespaces = new Hashtable(75);
        this.instances = 1;
    }

    public synchronized void rescheduleRefresh(int millisec) {
        if (this.theTimer != null) {
            this.theTimer.cancel();
        }
        this.theTimer = null;
        logger.info((Object)("Rescheduling refresh interval to " + millisec + " milliseconds"));
        this.theTimer = new Timer(true);
        this.theTimer.scheduleAtFixedRate((TimerTask)new Refreshener(), millisec, (long)millisec);
    }

    public synchronized void stopRefresh() {
        if (this.instances != 0) {
            --this.instances;
        }
        if (this.instances == 0) {
            if (this.theTimer != null) {
                this.theTimer.cancel();
            }
            this.theTimer = null;
        }
    }

    protected synchronized void addInstance() {
        ++this.instances;
    }

    public synchronized void setAggressive(boolean b) {
        this.aggressive = b;
    }

    public synchronized LSCFile getLSC(String voName, String hostName) {
        Hashtable lscList = (Hashtable)this.lscfiles.get(voName);
        if (lscList != null) {
            return (LSCFile)lscList.get(hostName);
        }
        return null;
    }

    public synchronized X509Certificate[] getAACandidate(X500Principal issuer, String voName) {
        Hashtable listCerts = (Hashtable)this.vomscerts.get(PKIUtils.getHash(issuer));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("listcerts content: " + listCerts));
        }
        if (listCerts != null) {
            HashSet certSet = (HashSet)listCerts.get(voName);
            if (certSet == null) {
                certSet = (HashSet)listCerts.get("");
            }
            if (certSet != null) {
                return certSet.toArray(new X509Certificate[0]);
            }
        }
        return null;
    }

    public synchronized void load() throws IOException, CertificateException, CRLException {
        switch (this.type) {
            case 1: {
                this.getForVOMS(new File(this.certDir), null);
                break;
            }
            case 2: {
                this.getForCA(new File(this.certDir));
                break;
            }
        }
    }

    private void load(X509Certificate cert, String voname) {
        if (cert == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("CERT = " + cert + " , vo = " + voname));
        }
        String hash = PKIUtils.getHash(cert);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registered HASH: " + hash + " for " + cert.getSubjectDN().getName() + " for vo: " + voname));
            logger.debug((Object)("Class of getSubjectDN: " + cert.getSubjectDN().getClass()));
            logger.debug((Object)("KNOWN HASH ? " + this.vomscerts.containsKey(hash)));
            logger.debug((Object)("VOMSCERTS = " + this.vomscerts));
        }
        if (this.vomscerts.containsKey(hash)) {
            logger.debug((Object)"Already exixtsing HASH");
            Hashtable certList = (Hashtable)this.vomscerts.get(hash);
            HashSet voSet = (HashSet)certList.get(voname);
            if (voSet != null) {
                voSet.add(cert);
            } else {
                HashSet<X509Certificate> set = new HashSet<X509Certificate>();
                set.add(cert);
                certList.put(voname, set);
            }
        } else {
            logger.debug((Object)"Originally EMPTY table");
            Hashtable certList = new Hashtable(75);
            HashSet<X509Certificate> set = new HashSet<X509Certificate>();
            set.add(cert);
            certList.put(voname, set);
            this.vomscerts.put(hash, certList);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Inserted HASH: " + hash));
                logger.debug((Object)("NEW VOMSCERTS = " + this.vomscerts));
            }
        }
    }

    private void load(X509Certificate[] certs, String voname) {
        int len = certs.length;
        logger.debug((Object)("LEN = " + len));
        for (int i = 0; i < len; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PARSING: " + i + " value: " + certs[i]));
            }
            this.load(certs[i], voname);
        }
    }

    private void load(X509Certificate cert) {
        String hash = PKIUtils.getHash(cert);
        if (this.certificates.containsKey(hash)) {
            if (!((Vector)this.certificates.get(hash)).contains(cert)) {
                ((Vector)this.certificates.get(hash)).add(cert);
            }
        } else {
            Vector<X509Certificate> certs = new Vector<X509Certificate>();
            certs.add(cert);
            this.certificates.put(hash, certs);
        }
    }

    private void load(X509Certificate[] certs) {
        int len = certs.length;
        for (int i = 0; i < len; ++i) {
            this.load(certs[i]);
        }
    }

    private void load(X509CRL crl) {
        String hash = PKIUtils.getHash(crl);
        if (this.crls.containsKey(hash)) {
            ((Vector)this.crls.get(hash)).add(crl);
        } else {
            Vector<X509CRL> c = new Vector<X509CRL>();
            c.add(crl);
            this.crls.put(hash, c);
        }
    }

    private void load(SigningPolicy sp) {
        String key = sp.getName();
        this.signings.put(key, sp);
    }

    private void load(Namespace nsp) {
        String key = nsp.getName();
        this.namespaces.put(key, nsp);
    }

    private void load(LSCFile lsc, String vo) {
        String key = lsc.getName();
        Hashtable lscList = null;
        if (!this.lscfiles.containsKey(vo)) {
            lscList = new Hashtable();
            this.lscfiles.put(vo, lscList);
        }
        if (lscList == null) {
            lscList = (Hashtable)this.lscfiles.get(vo);
        }
        lscList.put(key, lsc);
    }

    private void getForCA(File file) throws IOException, CertificateException, CRLException {
        File[] files = file.listFiles();
        for (File f : Arrays.asList(files)) {
            logger.debug((Object)("filename: " + f.getName()));
            try {
                Couple c = this.getObject(f);
                if (c == null) continue;
                int value = (Integer)c.second;
                logger.debug((Object)("TYPE: " + value));
                if (value == 2) {
                    this.load((X509CRL)c.first);
                    continue;
                }
                if (value == 1) {
                    X509Certificate[] arr = new X509Certificate[]{};
                    this.load(((List)c.first).toArray(arr));
                    continue;
                }
                if (value == 3) {
                    this.load((SigningPolicy)c.first);
                    continue;
                }
                if (value != 5) continue;
                this.load((Namespace)c.first);
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                f = null;
                if (this.aggressive) continue;
                throw e;
            }
            catch (CRLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                f = null;
                if (this.aggressive) continue;
                throw e;
            }
            catch (CertificateException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                f = null;
                if (this.aggressive) continue;
                throw e;
            }
        }
    }

    private void getForVOMS(File file, String vo) throws IOException, CertificateException, CRLException {
        File[] files = file.listFiles();
        Iterator<File> contents = Arrays.asList(files).iterator();
        if (vo == null) {
            vo = "";
        }
        logger.debug((Object)("For VO: " + vo));
        while (contents.hasNext()) {
            File f = contents.next();
            try {
                logger.debug((Object)("NAME: " + f.getName()));
                if (!f.isDirectory()) {
                    Couple c = this.getObject(f);
                    if (c != null) {
                        int value = (Integer)c.second;
                        logger.debug((Object)("TYPE: " + value));
                        if (value == 1) {
                            X509Certificate[] arr = new X509Certificate[]{};
                            this.load(((List)c.first).toArray(arr), vo);
                        } else if (value == 4) {
                            this.load((LSCFile)c.first, vo);
                            if (logger.isDebugEnabled()) {
                                Vector v = ((LSCFile)c.first).getDNLists();
                                ListIterator li = v.listIterator();
                                int i = 0;
                                while (li.hasNext()) {
                                    logger.debug((Object)("Sequence: " + i));
                                    Vector w = (Vector)li.next();
                                    ListIterator li2 = w.listIterator();
                                    while (li2.hasNext()) {
                                        logger.debug((Object)("DN: " + (String)li2.next()));
                                    }
                                }
                            }
                        }
                    }
                } else if (vo.equals("")) {
                    this.getForVOMS(f, f.getName());
                }
                f = null;
            }
            catch (CertificateException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                f = null;
                if (this.aggressive) continue;
                throw e;
            }
            catch (CRLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                f = null;
                if (this.aggressive) continue;
                throw e;
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                f = null;
                if (this.aggressive) continue;
                throw e;
            }
        }
    }

    private Couple getObject(File f) throws IOException, CertificateException, CRLException {
        if (f.getName().matches(".*\\.lsc")) {
            return new Couple(new LSCFile(f), 4);
        }
        if (f.getName().matches(".*\\.signing_policy")) {
            return new Couple(new SigningPolicy(f), 3);
        }
        if (f.getName().matches(".*\\.namespace")) {
            return new Couple(new Namespace(f), 5);
        }
        Object o = null;
        try {
            o = PKIUtils.readObject(f);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Problem reading file " + f.getName() + ": " + e.getMessage()));
            return null;
        }
        if (o instanceof X509CRL) {
            return new Couple(o, 2);
        }
        if (o instanceof List) {
            return new Couple(o, 1);
        }
        return null;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private static class Couple {
        Object first;
        Object second;

        Couple(Object first, Object second) {
            this.first = first;
            this.second = second;
        }
    }

    private class Refreshener
    extends TimerTask {
        private Refreshener() {
        }

        public void run() {
            PKIStore.this.refresh();
        }
    }
}

