/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.SinglePubInfo;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class PKIPublicationInfo
implements DEREncodable {
    DERInteger action;
    Vector pubInfos = new Vector();

    public static PKIPublicationInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIPublicationInfo.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static PKIPublicationInfo getInstance(Object obj) {
        if (obj instanceof PKIPublicationInfo) {
            return (PKIPublicationInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PKIPublicationInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public PKIPublicationInfo(ASN1Sequence seq) {
        this.action = DERInteger.getInstance((Object)seq.getObjectAt(0));
        if (seq.size() > 1) {
            ASN1Sequence s = (ASN1Sequence)seq.getObjectAt(1);
            for (int i = 0; i < s.size(); ++i) {
                this.pubInfos.addElement(SinglePubInfo.getInstance(s.getObjectAt(i)));
            }
        }
    }

    public PKIPublicationInfo(DERInteger action) {
        this.action = action;
    }

    public DERInteger getAction() {
        return this.action;
    }

    public SinglePubInfo getPubInfo(int nr) {
        if (this.pubInfos.size() > nr) {
            return (SinglePubInfo)this.pubInfos.elementAt(nr);
        }
        return null;
    }

    public void addPubInfo(SinglePubInfo pubInfo) {
        this.pubInfos.addElement(pubInfo);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.action);
        if (this.pubInfos.size() > 0) {
            ASN1EncodableVector pubiv = new ASN1EncodableVector();
            for (int i = 0; i < this.pubInfos.size(); ++i) {
                pubiv.add((DEREncodable)((SinglePubInfo)this.pubInfos.elementAt(i)));
            }
            v.add((DEREncodable)new DERSequence(pubiv));
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "PKIPublicationInfo: (action = " + this.getAction();
        if (this.pubInfos.size() > 0) {
            s = s + "pubInfos : (";
            for (int i = 0; i < this.pubInfos.size(); ++i) {
                s = s + (SinglePubInfo)this.pubInfos.elementAt(i);
            }
            s = s + ")";
        }
        s = s + ")";
        return s;
    }
}

