/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;

public class CertId
implements DEREncodable {
    GeneralName issuer;
    DERInteger serialNumber;

    public static CertId getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertId.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CertId getInstance(Object obj) {
        if (obj instanceof CertId) {
            return (CertId)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertId((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertId(ASN1Sequence seq) {
        this.issuer = GeneralName.getInstance((ASN1TaggedObject)((ASN1TaggedObject)seq.getObjectAt(0)), (boolean)true);
        this.serialNumber = (DERInteger)seq.getObjectAt(1);
    }

    public CertId(GeneralName issuer, DERInteger serialNumber) {
        this.issuer = issuer;
        this.serialNumber = serialNumber;
    }

    public GeneralName getIssuer() {
        return this.issuer;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.issuer);
        v.add((DEREncodable)this.serialNumber);
        return new DERSequence(v);
    }

    public String toString() {
        return "CertId: (issuer = " + this.getIssuer() + ", serialNumber = " + this.getSerialNumber() + ")";
    }
}

