/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public class CertConfirmContent
implements DEREncodable {
    ASN1OctetString certHash;
    DERInteger certReqId;
    PKIStatusInfo statusInfo;

    public static CertConfirmContent getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertConfirmContent.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CertConfirmContent getInstance(Object obj) {
        if (obj instanceof CertConfirmContent) {
            return (CertConfirmContent)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertConfirmContent((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertConfirmContent(ASN1Sequence seq) {
        ASN1Sequence s = ASN1Sequence.getInstance((Object)seq.getObjectAt(0));
        this.certHash = ASN1OctetString.getInstance((Object)s.getObjectAt(0));
        this.certReqId = DERInteger.getInstance((Object)s.getObjectAt(1));
        this.statusInfo = null;
        if (s.size() > 2) {
            this.statusInfo = PKIStatusInfo.getInstance(s.getObjectAt(2));
        }
    }

    public CertConfirmContent(ASN1OctetString certHash, DERInteger certReqId) {
        this.certHash = certHash;
        this.certReqId = certReqId;
        this.statusInfo = null;
    }

    public DERInteger getCertReqId() {
        return this.certReqId;
    }

    public ASN1OctetString getCertHash() {
        return this.certHash;
    }

    public PKIStatusInfo getPKIStatus() {
        return this.statusInfo;
    }

    public void setPKIStatus(PKIStatusInfo status) {
        this.statusInfo = status;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector outer = new ASN1EncodableVector();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.certHash);
        v.add((DEREncodable)this.certReqId);
        if (this.statusInfo != null) {
            v.add((DEREncodable)this.statusInfo);
        }
        outer.add((DEREncodable)new DERSequence(v));
        return new DERSequence(outer);
    }

    public String toString() {
        String s = "CertConfirmContent: (certHash = " + this.getCertHash() + ", certReqId = " + this.getCertReqId();
        if (this.getPKIStatus() != null) {
            s = s + "pkiStatus = " + this.getPKIStatus();
        }
        s = s + ")";
        return s;
    }
}

