/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.config;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import net.jcip.annotations.NotThreadSafe;
import org.glite.authz.common.config.AbstractConfiguration;
import org.glite.authz.common.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class AbstractConfigurationBuilder<ConfigType extends AbstractConfiguration> {
    private String loggingConfigFilePath;
    private X509KeyManager keyManager;
    private X509CertChainValidatorExt certChainValidator;
    private X509TrustManager trustManager;
    private int maxConnections;
    private int connectionTimeout;
    private int receiveBufferSize;
    private int sendBufferSize;

    protected AbstractConfigurationBuilder() {
        this.maxConnections = 0;
        this.connectionTimeout = 0;
        this.receiveBufferSize = 0;
        this.sendBufferSize = 0;
        this.keyManager = null;
        this.trustManager = null;
    }

    protected AbstractConfigurationBuilder(AbstractConfiguration prototype) {
        this.keyManager = prototype.getKeyManager();
        this.trustManager = prototype.getTrustManager();
        this.certChainValidator = prototype.getCertChainValidator();
        this.maxConnections = prototype.getMaxRequests();
        this.connectionTimeout = prototype.getConnectionTimeout();
        this.receiveBufferSize = prototype.getReceiveBufferSize();
        this.sendBufferSize = prototype.getSendBufferSize();
    }

    public abstract ConfigType build();

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getLoggingConfigFilePath() {
        return this.loggingConfigFilePath;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public X509KeyManager getKeyManager() {
        return this.keyManager;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public X509CertChainValidatorExt getCertChainValidator() {
        return this.certChainValidator;
    }

    public void setCertChainValidator(X509CertChainValidatorExt validator) {
        this.certChainValidator = validator;
    }

    protected void populateConfiguration(ConfigType config) {
        ((AbstractConfiguration)config).setConnectionTimeout(this.connectionTimeout);
        ((AbstractConfiguration)config).setMaxRequests(this.maxConnections);
        ((AbstractConfiguration)config).setReceiveBufferSize(this.receiveBufferSize);
        ((AbstractConfiguration)config).setSendBufferSize(this.sendBufferSize);
        ((AbstractConfiguration)config).setKeyManager(this.keyManager);
        ((AbstractConfiguration)config).setCertChainValidator(this.certChainValidator);
        ((AbstractConfiguration)config).setTrustManager(this.trustManager);
    }

    public void setConnectionTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException("Connection timeout may not be less than 1 millisecond");
        }
        this.connectionTimeout = timeout;
    }

    public void setLoggingConfigFilePath(String path) {
        this.loggingConfigFilePath = Strings.safeTrimOrNullString(path);
    }

    public void setMaxConnections(int max) {
        if (max < 1) {
            throw new IllegalArgumentException("Maximum number of threads may not be less than 1");
        }
        this.maxConnections = max;
    }

    public void setReceiveBufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Request buffer size may not be less than 1 byte in size");
        }
        this.receiveBufferSize = size;
    }

    public void setSendBufferSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Send buffer size may not be less than 1 byte in size");
        }
        this.sendBufferSize = size;
    }

    public void setKeyManager(X509KeyManager manager) {
        this.keyManager = manager;
    }

    public void setTrustManager(X509TrustManager manager) {
        this.trustManager = manager;
    }
}

