/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.fqan;

import java.text.ParseException;
import org.glite.authz.common.util.Strings;

public class FQAN {
    public static final String ROLE = "Role";
    public static final String CAPABILITY = "Capability";
    public static final String NULL = "NULL";
    public static final String WILDCARD = "*";
    private String groupName;
    private String role;
    private String capability;

    public FQAN(String fqanGroupName, String fqanRole, String fqanCapability) {
        this.groupName = Strings.safeTrimOrNullString(fqanGroupName);
        if (this.groupName == null) {
            throw new IllegalArgumentException("Group name may not be null");
        }
        if (this.groupName.endsWith("/")) {
            this.groupName = this.groupName.substring(0, this.groupName.length() - 1);
        }
        this.role = Strings.safeTrimOrNullString(fqanRole);
        if (this.role == null || this.role.equalsIgnoreCase(NULL)) {
            this.role = NULL;
        }
        this.capability = Strings.safeTrimOrNullString(fqanCapability);
        if (this.capability == null || this.capability.equalsIgnoreCase(NULL)) {
            this.capability = NULL;
        }
    }

    public FQAN(String fqanGroupName, String fqanRole) {
        this(fqanGroupName, fqanRole, null);
    }

    public FQAN(String fqanGroupName) {
        this(fqanGroupName, null, null);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getRole() {
        return this.role;
    }

    public String getCapability() {
        return this.capability;
    }

    public static FQAN parseFQAN(String fqan) throws ParseException {
        String trimmed = Strings.safeTrimOrNullString(fqan);
        if (trimmed == null) {
            return null;
        }
        if (!trimmed.startsWith("/")) {
            throw new ParseException("FQANs must start with a /", 0);
        }
        String[] components = trimmed.split("/");
        StringBuilder groupName = new StringBuilder();
        String role = null;
        String capability = null;
        for (String component : components) {
            if (component.contains("=")) {
                String[] subComponents = component.split("=");
                if (subComponents.length == 1) continue;
                if (subComponents.length > 2) {
                    throw new ParseException("Non group name components may not contain an = in their value: " + component, fqan.indexOf(component));
                }
                if (subComponents[0].equalsIgnoreCase(ROLE)) {
                    if (role != null) {
                        throw new ParseException("Role may not appear more than once in an FQAN", fqan.indexOf(component));
                    }
                    role = subComponents[1];
                    continue;
                }
                if (subComponents[0].equalsIgnoreCase(CAPABILITY)) {
                    if (capability != null) {
                        throw new ParseException("Capability may not appear more than once in an FQAN", fqan.indexOf(component));
                    }
                    capability = subComponents[1];
                    continue;
                }
                throw new ParseException("FQAN contains an unknown, non-group-name component: " + component, fqan.indexOf(component));
            }
            if (Strings.isEmpty(component)) continue;
            groupName.append("/").append(component);
        }
        if (groupName.length() == 0) {
            throw new ParseException("FQAN did not contain a group name", 0);
        }
        return new FQAN(groupName.toString(), role, capability);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.groupName);
        if (!this.role.equalsIgnoreCase(NULL)) {
            sb.append('/').append(ROLE).append('=').append(this.role);
        }
        if (!this.capability.equalsIgnoreCase(NULL)) {
            sb.append('/').append(CAPABILITY).append('=').append(this.capability);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupName.hashCode();
        result = 31 * result + this.role.hashCode();
        result = 31 * result + this.capability.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FQAN otherFQAN = (FQAN)obj;
        return this.getGroupName().equals(otherFQAN.getGroupName()) && this.getRole().equals(otherFQAN.getRole()) && this.getCapability().equals(otherFQAN.getCapability());
    }

    public boolean matches(String regexp) throws ParseException {
        FQAN regexpFQAN = FQAN.parseFQAN(regexp);
        return this.matches(regexpFQAN);
    }

    public boolean matches(FQAN regexpFQAN) throws ParseException {
        return this.matchesGroupName(regexpFQAN) && this.matchesRole(regexpFQAN);
    }

    protected boolean matchesGroupName(FQAN regexpFQAN) throws ParseException {
        String regexpGroup = regexpFQAN.getGroupName();
        if (regexpGroup.contains(WILDCARD)) {
            String groupNameBase = regexpGroup.substring(0, regexpGroup.length() - 1);
            if (!groupNameBase.endsWith("/")) {
                throw new ParseException("Invalid regular expression within FQAN group name, name does not end with a '/*'", regexpGroup.length());
            }
            if (groupNameBase.contains(WILDCARD)) {
                throw new ParseException("Invalid regular expression within FQAN group name, name contains more than one '*'", regexpGroup.indexOf(WILDCARD));
            }
            if (groupNameBase.equals("/")) {
                throw new ParseException("Invalid regular expression within FQAN group name, VO not specified", 0);
            }
            String terminatedGroupName = this.groupName + "/";
            return terminatedGroupName.startsWith(groupNameBase);
        }
        return regexpGroup.equals(this.groupName);
    }

    protected boolean matchesRole(FQAN regexpFQAN) throws ParseException {
        String regexpRole = regexpFQAN.getRole();
        if (regexpRole.contains(WILDCARD)) {
            if (!regexpRole.equals(WILDCARD)) {
                throw new ParseException("Invalid regular expression within FQAN role, role is not '*'", regexpFQAN.toString().indexOf(regexpRole));
            }
            return true;
        }
        return regexpRole.equals(this.role);
    }
}

