/*
 * Decompiled with CFR 0.152.
 */
package org.glite.authz.common.config;

import eu.emi.security.authn.x509.CommonX509TrustManager;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.io.Reader;
import java.io.StringReader;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.glite.authz.common.config.AbstractIniConfigurationParser;
import org.glite.authz.common.config.AbstractServiceConfiguration;
import org.glite.authz.common.config.AbstractServiceConfigurationBuilder;
import org.glite.authz.common.config.ConfigurationException;
import org.glite.authz.common.config.IniConfigUtil;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.opensaml.ws.soap.client.http.TLSProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIniServiceConfigurationParser<ConfigurationType extends AbstractServiceConfiguration>
extends AbstractIniConfigurationParser<ConfigurationType> {
    public static final String SERVICE_SECTION_HEADER = "SERVICE";
    public static final String ENTITY_ID_PROP = "entityId";
    public static final String HOST_PROP = "hostname";
    public static final String PORT_PROP = "port";
    public static final String SSL_ON_PORT_PROP = "enableSSL";
    public static final String CLIENT_CERT_AUTHN_PROP = "requireClientCertAuthentication";
    public static final String ADMIN_HOST_PROP = "adminHost";
    public static final String DEFAULT_ADMIN_HOST = "localhost";
    public static final String ADMIN_PORT_PROP = "adminPort";
    public static final String ADMIN_PASSWORD_PROP = "adminPassword";
    public static final String REQUEST_QUEUE_PROP = "requestQueueSize";
    public static final boolean DEFAULT_SSL_ON_PROP = false;
    public static final boolean DEFAULT_CLIENT_CERT_AUTH = false;
    public static final int DEFAULT_REQUEST_QUEUE = 500;
    private final Logger log = LoggerFactory.getLogger(AbstractIniServiceConfigurationParser.class);

    @Override
    public ConfigurationType parse(Reader iniReader) throws ConfigurationException {
        return this.parseIni(iniReader);
    }

    @Override
    public ConfigurationType parse(String iniString) throws ConfigurationException {
        return this.parseIni(new StringReader(iniString));
    }

    protected abstract ConfigurationType parseIni(Reader var1) throws ConfigurationException;

    protected String getEntityId(Profile.Section configSection) throws ConfigurationException {
        return IniConfigUtil.getString(configSection, ENTITY_ID_PROP);
    }

    protected String getHostname(Profile.Section configSection) throws ConfigurationException {
        return IniConfigUtil.getString(configSection, HOST_PROP);
    }

    protected int getPort(Profile.Section configSection) {
        return IniConfigUtil.getInt(configSection, PORT_PROP, 0, 1, 65535);
    }

    protected boolean isSSLEnabled(Profile.Section configSection) {
        if (configSection == null) {
            return false;
        }
        if (configSection.containsKey((Object)"servicePrivateKey") && configSection.containsKey((Object)"serviceCertificate") && configSection.containsKey((Object)"trustInfoDir")) {
            return IniConfigUtil.getBoolean(configSection, SSL_ON_PORT_PROP, false);
        }
        return false;
    }

    protected boolean isClientCertAuthRequired(Profile.Section configSection) {
        if (configSection == null) {
            return false;
        }
        if (this.isSSLEnabled(configSection)) {
            return IniConfigUtil.getBoolean(configSection, CLIENT_CERT_AUTHN_PROP, false);
        }
        return false;
    }

    protected String getAdminHost(Profile.Section configSection) {
        return IniConfigUtil.getString(configSection, ADMIN_HOST_PROP, DEFAULT_ADMIN_HOST);
    }

    protected int getAdminPort(Profile.Section configSection) {
        return IniConfigUtil.getInt(configSection, ADMIN_PORT_PROP, 0, 1, 65535);
    }

    protected String getAdminPassword(Profile.Section configSection) {
        return IniConfigUtil.getString(configSection, ADMIN_PASSWORD_PROP, null);
    }

    protected int getMaxRequestQueueSize(Profile.Section configSection) {
        return IniConfigUtil.getInt(configSection, REQUEST_QUEUE_PROP, 500, 1, Integer.MAX_VALUE);
    }

    protected void processServiceSection(Ini iniFile, AbstractServiceConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        Profile.Section configSection = (Profile.Section)iniFile.get((Object)SERVICE_SECTION_HEADER);
        if (configSection == null) {
            String errorMsg = "INI configuration does not contain the required 'SERVICE' INI section";
            this.log.error(errorMsg);
            throw new ConfigurationException(errorMsg);
        }
        String name = configSection.getName();
        String entityId = this.getEntityId(configSection);
        this.log.info("{}: entity ID: {}", (Object)name, (Object)entityId);
        configBuilder.setEntityId(entityId);
        String host = this.getHostname(configSection);
        this.log.info("{}: service hostname: {}", (Object)name, (Object)host);
        configBuilder.setHost(host);
        int port = this.getPort(configSection);
        this.log.info("{}: service port: {}", (Object)name, (Object)port);
        configBuilder.setPort(port);
        String adminHost = this.getAdminHost(configSection);
        this.log.info("{}: service admin hostname: {}", (Object)name, (Object)(adminHost == null ? "default" : adminHost));
        configBuilder.setAdminHost(adminHost);
        int adminPort = this.getAdminPort(configSection);
        this.log.info("{}: service admin port: {}", (Object)name, adminPort == 0 ? "default" : Integer.valueOf(adminPort));
        configBuilder.setAdminPort(adminPort);
        String adminPassword = this.getAdminPassword(configSection);
        this.log.info("{}: service admin password set: {}", (Object)name, (Object)(adminPassword == null ? "no" : "yes"));
        configBuilder.setAdminPassword(adminPassword);
        int maxConnections = this.getMaximumRequests(configSection);
        this.log.info("{}: max requests: {}", (Object)name, (Object)maxConnections);
        configBuilder.setMaxConnections(maxConnections);
        int connTimeout = this.getConnectionTimeout(configSection);
        this.log.info("{}: connection timeout: {}ms", (Object)name, (Object)connTimeout);
        configBuilder.setConnectionTimeout(connTimeout);
        int maxReqQueue = this.getMaxRequestQueueSize(configSection);
        this.log.info("{}: max request queue size: {}", (Object)name, (Object)maxReqQueue);
        configBuilder.setMaxRequestQueueSize(maxReqQueue);
        int receiveBuffer = this.getReceiveBufferSize(configSection);
        this.log.info("{}: recieve buffer size: {} bytes", (Object)name, (Object)receiveBuffer);
        configBuilder.setReceiveBufferSize(receiveBuffer);
        int sendBuffer = this.getSendBufferSize(configSection);
        this.log.info("{}: send buffer size: {} bytes", (Object)name, (Object)sendBuffer);
        configBuilder.setSendBufferSize(sendBuffer);
    }

    protected void processSecuritySection(Ini iniFile, AbstractServiceConfigurationBuilder<?> configBuilder) throws ConfigurationException {
        Profile.Section securityConfig = (Profile.Section)iniFile.get((Object)"SECURITY");
        if (securityConfig == null) {
            this.log.warn("INI configuration does not contain the '{}' section", (Object)"SECURITY");
        }
        String name = securityConfig.getName();
        X509KeyManager x509KeyManager = this.getX509KeyManager(securityConfig);
        configBuilder.setKeyManager(x509KeyManager);
        X509CertChainValidatorExt validator = this.getX509CertChainValidator(securityConfig);
        configBuilder.setCertChainValidator(validator);
        CommonX509TrustManager x509TrustManager = new CommonX509TrustManager((X509CertChainValidator)validator);
        configBuilder.setTrustManager((X509TrustManager)x509TrustManager);
        boolean sslOn = this.isSSLEnabled(securityConfig);
        this.log.info("{}: service port using SSL: {}", (Object)name, (Object)sslOn);
        configBuilder.setSslEnabled(sslOn);
        boolean clientCertAuthRequired = this.isClientCertAuthRequired(securityConfig);
        this.log.info("{}: TLS client certificate authentication required: {}", (Object)name, (Object)clientCertAuthRequired);
        configBuilder.setClientCertAuthRequired(clientCertAuthRequired);
    }

    protected HttpClientBuilder buildSOAPClientBuilder(Profile.Section configSection, X509KeyManager keyManager, X509TrustManager trustManager) {
        String name = configSection.getName();
        this.log.info("{}: building SOAP client ({})", (Object)name, (Object)(keyManager != null && trustManager != null ? "SSL" : "plain"));
        HttpClientBuilder httpClientBuilder = new HttpClientBuilder();
        httpClientBuilder.setContentCharSet("UTF-8");
        int conTimeout = this.getConnectionTimeout(configSection);
        this.log.info("{}: connection timeout: {}ms", (Object)name, (Object)conTimeout);
        httpClientBuilder.setConnectionTimeout(conTimeout);
        int maxRequests = this.getMaximumRequests(configSection);
        this.log.info("{}: maximum requests: {}", (Object)name, (Object)maxRequests);
        httpClientBuilder.setMaxTotalConnections(maxRequests);
        httpClientBuilder.setMaxConnectionsPerHost(maxRequests);
        int recBuffSize = this.getSendBufferSize(configSection);
        this.log.info("{}: recieve buffer size: {} bytes", (Object)name, (Object)recBuffSize);
        httpClientBuilder.setReceiveBufferSize(recBuffSize);
        int sendBuffSize = this.getSendBufferSize(configSection);
        this.log.info("{}: send buffer size: {} bytes", (Object)name, (Object)sendBuffSize);
        httpClientBuilder.setSendBufferSize(sendBuffSize);
        if (keyManager != null && trustManager != null) {
            this.log.debug("adding configured X509 key & trust manager to SOAP client");
            TLSProtocolSocketFactory factory = new TLSProtocolSocketFactory(keyManager, trustManager);
            httpClientBuilder.setHttpsProtocolSocketFactory((SecureProtocolSocketFactory)factory);
        }
        return httpClientBuilder;
    }
}

