__author__ = 'Elisabetta Ronchieri'

import sys
import os
import simplejson
import exceptions

class FileNotFound(exceptions.Exception):
    pass

def get_file_name(file_name):
    found = False
    new_file = ''
    for dir in sys.path:
        new_file = os.path.join(dir,file_name)
        if os.path.isfile(new_file):
            found = True
            break
    return found, new_file 

def get_json_file_information(file_name = 'size-images-info.json'):
    '''Get size images information of providers'''
    found, valid_file_name = get_file_name('wnodes/cli/providers/'+file_name)
    if found:
        try:
            tp_info=simplejson.load(open(valid_file_name,'r'))
        except ValueError, err:
            print "Wrong json file: %s" % err
            sys.exit(2)
    else:
        raise FileNotFound('Please check component installation')

    return tp_info
