/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.local;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.soap.SoapTransport;
import org.codehaus.xfire.soap.SoapTransportHelper;
import org.codehaus.xfire.transport.AbstractTransport;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.DefaultEndpoint;
import org.codehaus.xfire.transport.MapSession;
import org.codehaus.xfire.transport.Session;
import org.codehaus.xfire.transport.local.LocalChannel;

public class LocalTransport
extends AbstractTransport
implements SoapTransport {
    private static final Log log = LogFactory.getLog(LocalTransport.class);
    public static final String BINDING_ID = "urn:xfire:transport:local";
    public static final String URI_PREFIX = "xfire.local://";
    private Session session;
    private boolean maintainSession;

    public LocalTransport() {
        SoapTransportHelper.createSoapTransport(this);
    }

    protected Channel createNewChannel(String uri) {
        log.debug("Creating new channel for uri: " + uri);
        LocalChannel c = new LocalChannel(uri, this, this.session);
        c.setEndpoint(new DefaultEndpoint());
        return c;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
        this.resetSession();
    }

    public void resetSession() {
        this.session = this.maintainSession ? new MapSession() : null;
    }

    protected String getUriPrefix() {
        return URI_PREFIX;
    }

    public String[] getSupportedBindings() {
        return new String[]{BINDING_ID};
    }

    public String[] getKnownUriSchemes() {
        return new String[]{URI_PREFIX};
    }

    public String getName() {
        return "Local";
    }

    public String[] getSoapTransportIds() {
        return new String[]{BINDING_ID};
    }
}

