/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.service.binding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.Binding;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.AbstractBinding;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.binding.ServiceRunner;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.util.stax.JDOMStreamReader;
import org.codehaus.xfire.util.stax.JDOMStreamWriter;
import org.jdom.Element;
import org.jdom.Namespace;

public class ServiceInvocationHandler
extends AbstractHandler {
    private static final Log logger = LogFactory.getLog(AbstractBinding.class.getName());

    public ServiceInvocationHandler() {
        this.setPhase("service");
    }

    public void invoke(final MessageContext context) throws Exception {
        try {
            List params = (List)context.getInMessage().getBody();
            final OperationInfo operation = context.getExchange().getOperation();
            Binding binding = context.getBinding();
            MessageInfo msg = AbstractBinding.getIncomingMessageInfo(context);
            MessageInfo outMsg = AbstractBinding.getOutgoingMessageInfo(context);
            MessagePartContainer headerMsg = binding.getHeaders(msg);
            MessagePartContainer outHeaderMsg = null;
            if (outMsg != null) {
                outHeaderMsg = binding.getHeaders(outMsg);
            }
            final Object[] paramArray = this.fillInHolders(context, operation, msg, outMsg, headerMsg, outHeaderMsg, params);
            context.getInMessage().setBody(paramArray);
            ServiceInvocationHandler.readHeaders(context, headerMsg, paramArray);
            final Invoker invoker = context.getService().getInvoker();
            ServiceRunner runnable = new ServiceRunner(){

                public void run() {
                    try {
                        ServiceInvocationHandler.this.sendMessage(context, paramArray, operation, invoker);
                    }
                    catch (Exception e) {
                        XFireFault fault = XFireFault.createFault(e);
                        try {
                            context.getCurrentPipeline().pause();
                            context.setProperty("exception", fault);
                            context.getCurrentPipeline().handleFault(fault, context);
                            context.getFaultHandler().invoke(context);
                        }
                        catch (Exception e1) {
                            logger.warn("Error invoking fault handler.", e1);
                        }
                    }
                }
            };
            this.execute(runnable, context.getService(), operation);
        }
        catch (XFireRuntimeException e) {
            logger.warn("Error invoking service.", e);
            throw new XFireFault("Error invoking service" + (e.getMessage() != null ? ": " + e.getMessage() : "."), e, XFireFault.SENDER);
        }
    }

    protected void execute(Runnable runnable, Service service, OperationInfo operation) {
        Object executor = null;
        if (service != null) {
            executor = service.getExecutor();
        }
        if (executor == null) {
            if (!operation.isAsync()) {
                runnable.run();
            } else {
                Thread opthread = new Thread(runnable);
                opthread.start();
            }
        } else {
            try {
                Method method = executor.getClass().getMethod("execute", Runnable.class);
                method.invoke(executor, runnable);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new XFireRuntimeException("Could not invoke executor.", e);
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not invoke executor.", e);
            }
        }
    }

    public static Object readHeaders(MessageContext context, MessagePartContainer headerMsg, Object[] paramArray) throws XFireFault {
        List headerInfos = headerMsg.getMessageParts();
        Object result = null;
        Iterator itr = headerInfos.iterator();
        while (itr.hasNext()) {
            MessagePartInfo header = (MessagePartInfo)itr.next();
            BindingProvider provider = context.getService().getBindingProvider();
            XMLStreamReader headerReader = ServiceInvocationHandler.getXMLStreamReader(context.getInMessage(), header);
            if (headerReader == null) continue;
            Object headerVal = provider.readParameter(header, headerReader, context);
            if (header.getIndex() == -1) {
                result = headerVal;
                continue;
            }
            if (paramArray[header.getIndex()] != null) continue;
            paramArray[header.getIndex()] = headerVal;
        }
        return result;
    }

    protected Object[] fillInHolders(MessageContext context, OperationInfo opInfo, MessageInfo inMsg, MessageInfo outMsg, MessagePartContainer headerMsg, MessagePartContainer outHeaderMsg, List params) throws XFireFault {
        int outSize = 0;
        if (outMsg != null) {
            outSize = outMsg.size();
        }
        int headersNumber = this.calcuateHeaderSize(headerMsg, outHeaderMsg);
        int total = inMsg.size() + headersNumber + outSize;
        if (outMsg != null && outSize + outHeaderMsg.size() != 0) {
            --total;
        }
        if (total == params.size()) {
            return params.toArray();
        }
        Object[] newParams = new Object[total];
        List parts = inMsg.getMessageParts();
        if (params.size() < parts.size()) {
            throw new XFireFault("Not enough message parts were received for the operation.", XFireFault.SENDER);
        }
        for (int i = 0; i < parts.size(); ++i) {
            MessagePartInfo part = (MessagePartInfo)parts.get(i);
            newParams[part.getIndex()] = params.get(i);
        }
        if (!AbstractBinding.isClientModeOn(context) && outMsg != null) {
            this.fillInHolders(outMsg, newParams);
            this.fillInHolders(outHeaderMsg, newParams);
        }
        return newParams;
    }

    private int calcuateHeaderSize(MessagePartContainer headerMsg, MessagePartContainer outHeaderMsg) {
        MessagePartInfo info;
        Iterator iter;
        HashSet<QName> headers = new HashSet<QName>();
        if (headerMsg != null) {
            iter = headerMsg.getMessageParts().iterator();
            while (iter.hasNext()) {
                info = (MessagePartInfo)iter.next();
                headers.add(info.getName());
            }
        }
        if (outHeaderMsg != null) {
            iter = outHeaderMsg.getMessageParts().iterator();
            while (iter.hasNext()) {
                info = (MessagePartInfo)iter.next();
                headers.add(info.getName());
            }
        }
        return headers.size();
    }

    private void fillInHolders(MessagePartContainer msg, Object[] newParams) {
        Iterator itr = msg.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo part = (MessagePartInfo)itr.next();
            if (part.getIndex() < 0) continue;
            try {
                Object holder = part.getTypeClass().newInstance();
                newParams[part.getIndex()] = holder;
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Could not instantiate holder class.", e);
            }
        }
    }

    protected void sendMessage(MessageContext context, Object[] params, OperationInfo operation, Invoker invoker) throws Exception {
        Object value = invoker.invoke(operation.getMethod(), params, context);
        context.setProperty("postInvocationHandler.responseValue", value);
    }

    public static void writeHeaders(MessageContext context, Object responseValue) throws XFireFault, XMLStreamException {
        MessageInfo msgInfo = AbstractBinding.getOutgoingMessageInfo(context);
        MessagePartContainer headers = context.getBinding().getHeaders(msgInfo);
        if (headers.size() == 0) {
            return;
        }
        Object[] body = (Object[])context.getCurrentMessage().getBody();
        JDOMStreamWriter writer = new JDOMStreamWriter(context.getOutMessage().getOrCreateHeader());
        Iterator itr = headers.getMessageParts().iterator();
        while (itr.hasNext()) {
            MessagePartInfo part = (MessagePartInfo)itr.next();
            Object value = part.getIndex() == -1 ? responseValue : body[part.getIndex()];
            AbstractBinding.writeParameter(writer, context, value, part, part.getName().getNamespaceURI());
        }
    }

    private static XMLStreamReader getXMLStreamReader(AbstractMessage msg, MessagePartInfo header) {
        if (msg.getHeader() == null) {
            return null;
        }
        QName name = header.getName();
        Element el = msg.getHeader().getChild(name.getLocalPart(), Namespace.getNamespace(name.getNamespaceURI()));
        if (el == null) {
            return null;
        }
        JDOMStreamReader reader = new JDOMStreamReader(el);
        try {
            reader.next();
        }
        catch (XMLStreamException e) {
            // empty catch block
        }
        return reader;
    }
}

