/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.tracer.client;

import de.fzj.unicore.uas.util.Pair;
import java.util.GregorianCalendar;
import java.util.List;
import org.chemomentum.tracer.client.AndMessageQuery;
import org.chemomentum.tracer.client.IMessageQuery;
import org.chemomentum.tracer.client.NotMessageQuery;
import org.chemomentum.tracer.client.OrMessageQuery;
import org.chemomentum.tracer.client.PatternMessageQuery;
import org.chemomentum.tracer.client.TimeMessageQuery;
import org.chemomentum.tracer.client.TraceQueryDescription;
import org.chemomentum.tracer.xmlbeans.Boundary;
import org.chemomentum.tracer.xmlbeans.ColumnNames;
import org.chemomentum.tracer.xmlbeans.JoinOfQueries;
import org.chemomentum.tracer.xmlbeans.KindOfQuery;
import org.chemomentum.tracer.xmlbeans.MessageFormatType;
import org.chemomentum.tracer.xmlbeans.Negation;
import org.chemomentum.tracer.xmlbeans.Operator;
import org.chemomentum.tracer.xmlbeans.PatternQuery;
import org.chemomentum.tracer.xmlbeans.ResponseFormatType;
import org.chemomentum.tracer.xmlbeans.TimeQuery;
import org.chemomentum.tracer.xmlbeans.TraceQueryDocument;

public class QueryToXMLConverter {
    public static TraceQueryDocument convert(TraceQueryDescription descr) throws Exception {
        TraceQueryDocument result = TraceQueryDocument.Factory.newInstance();
        TraceQueryDocument.TraceQuery traceQuery = TraceQueryDocument.TraceQuery.Factory.newInstance();
        traceQuery.setQuery(QueryToXMLConverter.convertQuery(descr.getQuery()));
        ResponseFormatType rft = ResponseFormatType.Factory.newInstance();
        if (descr.getMode() == 1) {
            rft.setPrintNumberOfMessages("Please give me the number of found messages!");
        } else {
            MessageFormatType mft = MessageFormatType.Factory.newInstance();
            Pair<String, String>[] pairs = descr.getBoundaries();
            Boundary[] bounds = new Boundary[pairs.length];
            int i = 0;
            while (i < pairs.length) {
                Boundary b = Boundary.Factory.newInstance();
                b.setBegin(pairs[i].getM1());
                b.setEnd(pairs[i].getM2());
                bounds[i] = b;
                ++i;
            }
            mft.setLimitMessagesArray(bounds);
            List<String> list = descr.getAttributes();
            int i2 = 0;
            while (i2 < list.size()) {
                mft.addSelectedColumns(ColumnNames.Enum.forString(list.get(i2)));
                ++i2;
            }
            rft.setMessageFormat(mft);
        }
        traceQuery.setResponseFormat(rft);
        result.setTraceQuery(traceQuery);
        return result;
    }

    private static KindOfQuery convertQuery(IMessageQuery koq) {
        KindOfQuery tq = KindOfQuery.Factory.newInstance();
        if (koq instanceof PatternMessageQuery) {
            tq.setPattern(QueryToXMLConverter.convertPatternQuery((PatternMessageQuery)koq));
        } else if (koq instanceof TimeMessageQuery) {
            tq.setTime(QueryToXMLConverter.convertTimeQuery((TimeMessageQuery)koq));
        } else if (koq instanceof AndMessageQuery || koq instanceof OrMessageQuery) {
            tq.setJoin(QueryToXMLConverter.convertJoinQuery(koq));
        } else if (koq instanceof NotMessageQuery) {
            tq.setNegation(QueryToXMLConverter.convertNegationQuery((NotMessageQuery)koq));
        }
        return tq;
    }

    private static JoinOfQueries convertJoinQuery(IMessageQuery koq) {
        JoinOfQueries join = JoinOfQueries.Factory.newInstance();
        if (koq instanceof AndMessageQuery) {
            join.setJoinOperator(Operator.AND);
            join.setLeftOperand(QueryToXMLConverter.convertQuery(((AndMessageQuery)koq).getLeft()));
            join.setRightOperand(QueryToXMLConverter.convertQuery(((AndMessageQuery)koq).getRight()));
        } else if (koq instanceof OrMessageQuery) {
            join.setJoinOperator(Operator.OR);
            join.setLeftOperand(QueryToXMLConverter.convertQuery(((OrMessageQuery)koq).getLeft()));
            join.setRightOperand(QueryToXMLConverter.convertQuery(((OrMessageQuery)koq).getRight()));
        }
        return join;
    }

    private static Negation convertNegationQuery(NotMessageQuery koq) {
        Negation neg = Negation.Factory.newInstance();
        neg.setOperand(QueryToXMLConverter.convertQuery(koq.getNegated()));
        return neg;
    }

    private static PatternQuery convertPatternQuery(PatternMessageQuery koq) {
        PatternQuery pq = PatternQuery.Factory.newInstance();
        pq.setColumn(koq.getField());
        pq.setPattern(koq.getPattern());
        return pq;
    }

    private static TimeQuery convertTimeQuery(TimeMessageQuery tmq) {
        TimeQuery tq = TimeQuery.Factory.newInstance();
        GregorianCalendar start = new GregorianCalendar();
        start.setTimeInMillis(tmq.getStart());
        GregorianCalendar end = new GregorianCalendar();
        end.setTimeInMillis(tmq.getEnd());
        tq.setBegin(start);
        tq.setEnd(end);
        return tq;
    }
}

