/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.util.jsdl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.chemomentum.common.util.jsdl.Interval;
import org.chemomentum.common.util.jsdl.IntervalEvent;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ExactType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.RangeValueType;

public class RangeValueUtils {
    public static boolean testIntersection(RangeValueType a, RangeValueType b) {
        List<Interval> aIntervals = RangeValueUtils.createIntervalsFromRangeValueType(a);
        List<Interval> bIntervals = RangeValueUtils.createIntervalsFromRangeValueType(b);
        aIntervals = RangeValueUtils.mergeIntervals(aIntervals);
        bIntervals = RangeValueUtils.mergeIntervals(bIntervals);
        return RangeValueUtils.testIntersection(aIntervals, bIntervals);
    }

    public static boolean fitsInto(RangeValueType a, RangeValueType b) {
        return RangeValueUtils.testIntersection(a, b);
    }

    public static RangeValueType transformExactIntoLowerBounds(RangeValueType r) {
        RangeValueType result = (RangeValueType)r.copy();
        ArrayList<ExactType> newExacts = new ArrayList<ExactType>();
        ArrayList<RangeType> newLowerBounded = new ArrayList<RangeType>();
        ExactType[] exacts = r.getExactArray();
        if (exacts != null) {
            RangeType[] ranges;
            ExactType[] exactTypeArray = exacts;
            int n = exacts.length;
            int n2 = 0;
            while (n2 < n) {
                ExactType exact = exactTypeArray[n2];
                if (exact.isSetEpsilon()) {
                    newExacts.add(exact);
                } else {
                    double lower = exact.getDoubleValue();
                    RangeType range = RangeType.Factory.newInstance();
                    range.addNewLowerBound().setDoubleValue(lower);
                    range.addNewUpperBound().setDoubleValue(Double.POSITIVE_INFINITY);
                    newLowerBounded.add(range);
                }
                ++n2;
            }
            result.setExactArray(newExacts.toArray(new ExactType[0]));
            RangeType[] rangeTypeArray = ranges = result.getRangeArray();
            int n3 = ranges.length;
            n = 0;
            while (n < n3) {
                RangeType rangeType = rangeTypeArray[n];
                newLowerBounded.add(0, rangeType);
                ++n;
            }
            result.setRangeArray(newLowerBounded.toArray(new RangeType[0]));
        }
        return result;
    }

    public static double getMinimum(RangeValueType r) {
        double result = Double.POSITIVE_INFINITY;
        List<Interval> intervals = RangeValueUtils.createIntervalsFromRangeValueType(r);
        for (Interval interval : intervals) {
            if (!(interval.getStart() < result)) continue;
            result = interval.getStart();
        }
        return result;
    }

    public static double getMaximum(RangeValueType r) {
        double result = Double.NEGATIVE_INFINITY;
        List<Interval> intervals = RangeValueUtils.createIntervalsFromRangeValueType(r);
        for (Interval interval : intervals) {
            if (!(interval.getEnd() > result)) continue;
            result = interval.getEnd();
        }
        return result;
    }

    public static boolean testIntersection(List<Interval> a, List<Interval> b) {
        ArrayList<IntervalEvent> events = new ArrayList<IntervalEvent>();
        ArrayList<Interval> intervals = new ArrayList<Interval>(a);
        intervals.addAll(b);
        for (Interval interval : intervals) {
            IntervalEvent start = new IntervalEvent(interval.getStart(), interval, 0);
            events.add(start);
            IntervalEvent end = new IntervalEvent(interval.getEnd(), interval, 1);
            events.add(end);
        }
        Collections.sort(events);
        int numIntervalsOnSweepLine = 0;
        for (IntervalEvent e : events) {
            switch (e.type) {
                case 0: {
                    ++numIntervalsOnSweepLine;
                    break;
                }
                case 1: {
                    --numIntervalsOnSweepLine;
                }
            }
            if (numIntervalsOnSweepLine <= 1) continue;
            return true;
        }
        return false;
    }

    public static List<Interval> mergeIntervals(List<Interval> intervals) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        ArrayList<IntervalEvent> events = new ArrayList<IntervalEvent>();
        for (Interval interval : intervals) {
            IntervalEvent start = new IntervalEvent(interval.getStart(), interval, 0);
            events.add(start);
            IntervalEvent end = new IntervalEvent(interval.getEnd(), interval, 1);
            events.add(end);
        }
        Collections.sort(events);
        Interval current = null;
        int numIntervalsOnSweepLine = 0;
        for (IntervalEvent e : events) {
            switch (e.type) {
                case 0: {
                    if (numIntervalsOnSweepLine == 0) {
                        current = new Interval(e.interval.getStart(), Double.POSITIVE_INFINITY, e.interval.containsStart(), false);
                    }
                    ++numIntervalsOnSweepLine;
                    break;
                }
                case 1: {
                    if (--numIntervalsOnSweepLine != 0) break;
                    current.setEnd(e.interval.getEnd());
                    current.setContainsEnd(e.interval.containsEnd());
                    result.add(current);
                }
            }
        }
        return result;
    }

    public static List<Interval> createIntervalsFromRangeValueType(RangeValueType r) {
        RangeType[] ranges;
        int n;
        ArrayList<Interval> result = new ArrayList<Interval>();
        ExactType[] exacts = r.getExactArray();
        if (exacts != null) {
            ExactType[] exactTypeArray = exacts;
            n = exacts.length;
            int n2 = 0;
            while (n2 < n) {
                Interval i;
                ExactType exact = exactTypeArray[n2];
                double mid = exact.getDoubleValue();
                if (exact.isSetEpsilon()) {
                    double epsilon = exact.getEpsilon();
                    i = new Interval(mid - epsilon, mid + epsilon);
                } else {
                    i = new Interval(mid, mid);
                }
                result.add(i);
                ++n2;
            }
        }
        if ((ranges = r.getRangeArray()) != null) {
            RangeType[] rangeTypeArray = ranges;
            int n3 = ranges.length;
            n = 0;
            while (n < n3) {
                RangeType range = rangeTypeArray[n];
                double start = range.getLowerBound().getDoubleValue();
                boolean containsStart = !range.getLowerBound().isSetExclusiveBound();
                double end = range.getUpperBound().getDoubleValue();
                boolean containsEnd = !range.getUpperBound().isSetExclusiveBound();
                Interval i = new Interval(start, end, containsStart, containsEnd);
                result.add(i);
                ++n;
            }
        }
        if (r.isSetLowerBoundedRange()) {
            double start = r.getLowerBoundedRange().getDoubleValue();
            boolean containsStart = !r.getLowerBoundedRange().isSetExclusiveBound();
            result.add(new Interval(start, Double.POSITIVE_INFINITY, containsStart, false));
        }
        if (r.isSetUpperBoundedRange()) {
            double end = r.getUpperBoundedRange().getDoubleValue();
            boolean containsEnd = !r.getUpperBoundedRange().isSetExclusiveBound();
            result.add(new Interval(Double.NEGATIVE_INFINITY, end, false, containsEnd));
        }
        return result;
    }
}

