/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.util.jsdl;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.chemomentum.workassignment.xmlbeans.AttributeDocument;
import org.chemomentum.workassignment.xmlbeans.DataStagingAttributesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;

public class Output {
    private String source;
    private String target;
    private DataStagingType stage;
    private Map<String, String> options;

    public Output() {
    }

    public Output(String source, String target) {
        this.source = source;
        this.target = target;
    }

    public Output(String source, String target, DataStagingType stage) {
        this.source = source;
        this.target = target;
        this.stage = stage;
        if (stage != null) {
            this.parseStagingOptions();
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
        if (this.stage != null) {
            this.stage.setFileName(source);
        }
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
        if (this.stage != null) {
            this.stage.getTarget().setURI(target);
        }
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    private void parseStagingOptions() {
        this.options = new HashMap<String, String>();
        try {
            XmlObject[] attributes = WSUtilities.extractAnyElements(this.stage, DataStagingAttributesDocument.type.getDocumentElementName());
            if (attributes.length > 0) {
                DataStagingAttributesDocument d = DataStagingAttributesDocument.Factory.parse(attributes[0].newXMLStreamReader());
                AttributeDocument.Attribute[] attributeArray = d.getDataStagingAttributes().getAttributeArray();
                int n = attributeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeDocument.Attribute attr = attributeArray[n2];
                    String name = attr.getName();
                    String value = attr.getStringValue();
                    this.options.put(name, value);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

