/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.util;

import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import eu.unicore.security.util.client.IClientProperties;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class RegistryCrawler {
    protected static Logger logger = Logger.getLogger(RegistryCrawler.class.getName());
    private String regUrl;
    private RegistryClient reg;

    public RegistryCrawler(EndpointReferenceType registry_epr, IClientProperties sp) {
        this.regUrl = registry_epr.getAddress().getStringValue();
        logger.debug("Trying to reach registry." + this.regUrl);
        try {
            this.reg = new RegistryClient(this.regUrl, registry_epr, sp);
        }
        catch (Exception e) {
            logger.log(Level.WARN, "Could not reach Registry at " + this.regUrl + "!", e);
        }
    }

    public List<EndpointReferenceType> findServiceInstances(QName port) {
        ArrayList<EndpointReferenceType> instances = new ArrayList();
        try {
            logger.debug("Searching for instances of type: " + port.getLocalPart());
            instances = this.reg.listServices(port);
        }
        catch (Exception e) {
            logger.log(Level.WARN, "Could not reach Registry at " + this.regUrl + "!", e);
        }
        return instances;
    }
}

