/*
 * Decompiled with CFR 0.152.
 */
package org.chemomentum.common.impl.workflow;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.security.util.client.IClientProperties;
import java.util.Arrays;
import java.util.List;
import org.chemomentum.common.api.workflow.WFClient;
import org.chemomentum.common.api.workflow.WorkflowWrapper;
import org.chemomentum.common.ws.WorkflowManagement;
import org.chemomentum.workflow.xmlbeans.AbortWorkflowRequestDocument;
import org.chemomentum.workflow.xmlbeans.DetailedStatusDocument;
import org.chemomentum.workflow.xmlbeans.StatusType;
import org.chemomentum.workflow.xmlbeans.SubmitWorkflowDocument;
import org.chemomentum.workflow.xmlbeans.SubmitWorkflowType;
import org.chemomentum.workflow.xmlbeans.SubmittedWorkflowDocument;
import org.chemomentum.workflow.xmlbeans.WorkflowResourcePropertiesDocument;
import org.chemomentum.workflow.xmlbeans.WorkflowStatusDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class WorkflowManagementClient
extends BaseUASClient
implements WFClient {
    protected final WorkflowManagement workflow = this.makeProxy(WorkflowManagement.class);
    protected final String workflowID = WSUtilities.extractResourceID(this.getEPR());
    protected WorkflowWrapper submittedWF;

    public WorkflowManagementClient(String url, EndpointReferenceType epr, IClientProperties sec) throws Exception {
        super(url, epr, sec);
    }

    @Override
    public void submitWorkflow(WorkflowWrapper wf) throws Exception {
        SubmitWorkflowDocument in = SubmitWorkflowDocument.Factory.newInstance();
        SubmitWorkflowType w = in.addNewSubmitWorkflow();
        w.setRules(wf.getRules());
        w.setWorkflow(wf.getWorkflow());
        if (wf.getStorageAddress() != null) {
            w.setStorageEPR(wf.getStorageAddress());
        }
        this.workflow.submit(in);
    }

    @Override
    public void abort() throws Exception {
        AbortWorkflowRequestDocument abort = AbortWorkflowRequestDocument.Factory.newInstance();
        abort.addNewAbortWorkflowRequest();
        this.workflow.abort(abort);
    }

    @Override
    public DetailedStatusDocument.DetailedStatus getDetailedStatus() throws Exception {
        DetailedStatusDocument s = DetailedStatusDocument.Factory.parse(this.getResourceProperty(WorkflowManagement.RPWorkflowDetailedStatus));
        return s.getDetailedStatus();
    }

    @Override
    public StatusType.Enum getStatus() throws Exception {
        WorkflowStatusDocument s = WorkflowStatusDocument.Factory.parse(this.getResourceProperty(WorkflowManagement.RPWorkflowStatus));
        return s.getWorkflowStatus();
    }

    @Override
    public WorkflowWrapper getSubmittedWorkflow() throws Exception {
        if (this.submittedWF == null) {
            SubmittedWorkflowDocument s = SubmittedWorkflowDocument.Factory.parse(this.getResourceProperty(WorkflowManagement.RPSubmittedWorkflow));
            this.submittedWF = new WorkflowWrapper();
            this.submittedWF.setWorkflow(s.getSubmittedWorkflow().getWorkflow());
            this.submittedWF.setRules(s.getSubmittedWorkflow().getRules());
        }
        return this.submittedWF;
    }

    @Override
    public String getWorkflowID() {
        return this.workflowID;
    }

    @Override
    public List<String> getOutputFiles() throws Exception {
        return Arrays.asList(this.getResourcePropertiesDocument().getWorkflowResourceProperties().getOutputFiles().getOutputFileArray());
    }

    @Override
    public WorkflowResourcePropertiesDocument getResourcePropertiesDocument() throws Exception {
        return WorkflowResourcePropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    @Override
    public EndpointReferenceType getTracerAddress() throws Exception {
        return this.getResourcePropertiesDocument().getWorkflowResourceProperties().getTracerAddress();
    }

    @Override
    public EndpointReferenceType getStorageAddress() throws Exception {
        return this.getResourcePropertiesDocument().getWorkflowResourceProperties().getStorageEPR();
    }
}

