/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMEnvelope
implements ExternalObjectModel,
Serializable {
    public String getIdentifyingURI() {
        return "http://java.sun.com/jaxp/xpath/dom";
    }

    public PJConverter getPJConverter(Class targetClass) {
        if (NodeOverNodeInfo.class.isAssignableFrom(targetClass)) {
            return new PJConverter(){

                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return DOMEnvelope.this.convertXPathValueToObject(value, targetClass, context);
                }
            };
        }
        if (NodeList.class.isAssignableFrom(targetClass)) {
            return new PJConverter(){

                public Object convert(ValueRepresentation value, Class targetClass, XPathContext context) throws XPathException {
                    return DOMEnvelope.this.convertXPathValueToObject(value, targetClass, context);
                }
            };
        }
        return null;
    }

    public JPConverter getJPConverter(Class targetClass) {
        if (NodeOverNodeInfo.class.isAssignableFrom(targetClass)) {
            return new JPConverter(){

                public ValueRepresentation convert(Object object, XPathContext context) throws XPathException {
                    return DOMEnvelope.this.convertObjectToXPathValue(object, context.getConfiguration());
                }

                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    public PJConverter getNodeListCreator(Object node) {
        return null;
    }

    public boolean isRecognizedNode(Object object) {
        return object instanceof NodeOverNodeInfo;
    }

    public boolean isRecognizedNodeClass(Class nodeClass) {
        return NodeOverNodeInfo.class.isAssignableFrom(nodeClass);
    }

    private boolean isRecognizedNodeListClass(Class nodeClass) {
        return NodeList.class.isAssignableFrom(nodeClass);
    }

    public Receiver getDocumentBuilder(Result result) throws XPathException {
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipe) throws XPathException {
        Node startNode;
        if (source instanceof DOMSource && (startNode = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo) {
            NodeInfo base = ((NodeOverNodeInfo)startNode).getUnderlyingNodeInfo();
            Sender driver = new Sender(pipe);
            driver.send(base, receiver);
            return true;
        }
        return false;
    }

    public NodeInfo unravel(Source source, Configuration config) {
        Node dsnode;
        if (source instanceof DOMSource && (dsnode = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)dsnode).getUnderlyingNodeInfo();
        }
        return null;
    }

    public ValueRepresentation convertObjectToXPathValue(Object object, Configuration config) throws XPathException {
        if (object instanceof NodeList) {
            NodeList list = (NodeList)object;
            int len = list.getLength();
            if (len == 0) {
                return null;
            }
            Item[] nodes = new NodeInfo[len];
            for (int i = 0; i < len; ++i) {
                if (!(list.item(i) instanceof NodeOverNodeInfo)) {
                    return null;
                }
                nodes[i] = ((NodeOverNodeInfo)list.item(i)).getUnderlyingNodeInfo();
            }
            return new SequenceExtent(nodes);
        }
        if (object instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)object).getUnderlyingNodeInfo();
        }
        return null;
    }

    public Object convertXPathValueToObject(ValueRepresentation value, Object targetClass, XPathContext context) throws XPathException {
        Item item;
        boolean allowDOM;
        Class target;
        boolean requireDOM = Node.class.isAssignableFrom(target = (Class)targetClass) || target == NodeList.class || target.isArray() && Node.class.isAssignableFrom(target.getComponentType());
        boolean bl = target == Object.class || target.isAssignableFrom(ArrayList.class) || target.isAssignableFrom(HashSet.class) || target.isArray() && target.getComponentType() == Object.class ? true : (allowDOM = false);
        if (!requireDOM && !allowDOM) {
            return null;
        }
        ArrayList<Object> nodes = new ArrayList<Object>(20);
        SequenceIterator iter = Value.asIterator(value);
        while ((item = iter.next()) != null) {
            if (item instanceof VirtualNode) {
                Object o = ((VirtualNode)item).getUnderlyingNode();
                if (o instanceof Node) {
                    nodes.add(o);
                    continue;
                }
                if (!requireDOM) continue;
                XPathException err = new XPathException("Extension function required class " + target.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                throw err;
            }
            if (requireDOM) {
                if (item instanceof NodeInfo) {
                    nodes.add(NodeOverNodeInfo.wrap((NodeInfo)item));
                    continue;
                }
                XPathException err = new XPathException("Extension function required class " + target.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                throw err;
            }
            return null;
        }
        if (nodes.size() == 0 && !requireDOM) {
            return null;
        }
        if (Node.class.isAssignableFrom(target)) {
            if (nodes.size() != 1) {
                XPathException err = new XPathException("Extension function requires a single DOM Node; supplied value contains " + nodes.size() + " nodes");
                throw err;
            }
            return nodes.get(0);
        }
        if (target == NodeList.class) {
            return new DOMNodeList(nodes);
        }
        if (target.isArray() && target.getComponentType() == Node.class) {
            Node[] array = new Node[nodes.size()];
            nodes.toArray(array);
            return array;
        }
        if (target.isAssignableFrom(ArrayList.class)) {
            return nodes;
        }
        if (target.isAssignableFrom(HashSet.class)) {
            return new HashSet(nodes);
        }
        return null;
    }

    public DocumentInfo wrapDocument(Object node, String baseURI, Configuration config) {
        DocumentInfo doc = null;
        if (node instanceof DocumentOverNodeInfo) {
            doc = (DocumentInfo)((DocumentOverNodeInfo)node).getUnderlyingNodeInfo();
        } else if (node instanceof NodeOverNodeInfo) {
            doc = ((NodeOverNodeInfo)node).getUnderlyingNodeInfo().getDocumentRoot();
        }
        if (doc == null) {
            throw new IllegalArgumentException("Unknown node class " + node.getClass());
        }
        if (doc.getConfiguration() != config) {
            throw new IllegalArgumentException("Externally-supplied DOM envelope belong to the wrong Configuration");
        }
        return doc;
    }

    public NodeInfo wrapNode(DocumentInfo document, Object node) {
        if (node instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)node).getUnderlyingNodeInfo();
        }
        throw new IllegalArgumentException("Unknown node class " + node.getClass());
    }
}

