/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.db;

import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertyMD;
import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;

public abstract class DBPropertiesHelper {
    @DocumentationReferencePrefix
    public static final String PREFIX = "db.";
    public static final String DIALECT = "dialect";
    public static final String USER = "username";
    public static final String PASSWORD = "password";
    public static final String URL = "jdbcUrl";
    public static final String DRIVER = "driver";
    public static final PropertyMD.DocumentationCategory dbCategory = new PropertyMD.DocumentationCategory("Database");

    public static <T extends Enum<T>> Map<String, PropertyMD> getMetadata(Class<? extends Driver> defaultDriver, String defaultUrl, T defaultDialect, String prefix) {
        HashMap<String, PropertyMD> ret = new HashMap<String, PropertyMD>();
        if (defaultDialect != null) {
            ret.put(String.valueOf(prefix) + DIALECT, new PropertyMD(defaultDialect).setCategory(dbCategory).setDescription("Database SQL dialect. Must match the selected driver, however sometimes more then one driver can be available for a dialect."));
        }
        ret.put(String.valueOf(prefix) + DRIVER, new PropertyMD(defaultDriver, Driver.class).setCategory(dbCategory).setDescription("Database driver class name. This property is optional - if not set, then a default driver for the chosen database type is used."));
        ret.put(String.valueOf(prefix) + URL, new PropertyMD(defaultUrl).setCategory(dbCategory).setDescription("Database JDBC URL."));
        ret.put(String.valueOf(prefix) + USER, new PropertyMD("sa").setCategory(dbCategory).setDescription("Database username."));
        ret.put(String.valueOf(prefix) + PASSWORD, new PropertyMD("").setCategory(dbCategory).setDescription("Database password."));
        return ret;
    }
}

