/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.configuration;

import java.util.Arrays;

public class PropertyMD
implements Cloneable {
    private boolean secret;
    private boolean hide;
    private String defaultValue;
    private boolean hasDefault;
    private boolean mandatory;
    private boolean canHaveSubkeys = false;
    private boolean numericalListKeys = false;
    private boolean updateable = false;
    private String description;
    private DocumentationCategory category;
    private String sortKey = null;
    private long min = Integer.MIN_VALUE;
    private long max = Integer.MAX_VALUE;
    private double minFloat = Double.MIN_VALUE;
    private double maxFloat = Double.MAX_VALUE;
    private Type type = Type.STRING;
    private Enum<?> enumTypeInstance;
    private Class<?> baseClass;

    public PropertyMD(String defaultValue) {
        this.defaultValue = defaultValue;
        this.hasDefault = true;
        this.type = this.isInt(defaultValue) ? Type.INT : (this.isLong(defaultValue) ? Type.LONG : (this.isFloat(defaultValue) ? Type.FLOAT : (this.isBoolean(defaultValue) ? Type.BOOLEAN : Type.STRING)));
    }

    public PropertyMD(Class<?> defaultValue, Class<?> baseClass) {
        this.defaultValue = defaultValue == null ? null : defaultValue.getName();
        this.baseClass = baseClass;
        if (defaultValue != null && !baseClass.isAssignableFrom(defaultValue)) {
            throw new IllegalArgumentException(defaultValue + " must extend " + baseClass);
        }
        this.hasDefault = true;
        this.type = Type.CLASS;
    }

    public <T extends Enum<T>> PropertyMD(T defaultValue) {
        this.enumTypeInstance = defaultValue;
        this.hasDefault = true;
        this.defaultValue = defaultValue.name();
        this.type = Type.ENUM;
    }

    public PropertyMD() {
    }

    public boolean isSecret() {
        return this.secret;
    }

    public PropertyMD setSecret() {
        this.secret = true;
        return this;
    }

    public boolean isHidden() {
        return this.hide;
    }

    public PropertyMD setHidden() {
        this.hide = true;
        return this;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public PropertyMD setDefault(String defaultValue) {
        if (this.isMandatory()) {
            throw new IllegalStateException("A property can not have a default value and be mandatory at the same time");
        }
        this.checkDefault(this.type, defaultValue);
        this.defaultValue = defaultValue;
        this.hasDefault = true;
        return this;
    }

    protected void checkDefault(Type type, String defaultValue) {
        if (defaultValue == null) {
            return;
        }
        if (type == Type.BOOLEAN && !this.isBoolean(defaultValue)) {
            throw new IllegalStateException("A property default type must be valid value of its type: boolean");
        }
        if (type == Type.INT && !this.isInt(defaultValue)) {
            throw new IllegalStateException("A property default type must be valid value of its type: int");
        }
        if (type == Type.LONG && !this.isLong(defaultValue)) {
            throw new IllegalStateException("A property default type must be valid value of its type: long");
        }
        if (type == Type.FLOAT && !this.isFloat(defaultValue)) {
            throw new IllegalStateException("A property default type must be valid value of its type: float");
        }
        if (type == Type.CLASS && !this.isClass(defaultValue)) {
            throw new IllegalStateException("A property default type must be valid value of its type: class");
        }
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public PropertyMD setMandatory() {
        if (this.hasDefault()) {
            throw new IllegalStateException("A property can not have a default value and be mandatory at the same time");
        }
        this.mandatory = true;
        return this;
    }

    public PropertyMD setDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean hasDefault() {
        return this.hasDefault;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }

    public PropertyMD setUpdateable() {
        this.updateable = true;
        return this;
    }

    public PropertyMD setBounds(long min, long max) {
        if (this.type != Type.INT && this.type != Type.LONG) {
            throw new IllegalStateException("Integer bounds can be only set for int or long property");
        }
        this.min = min;
        this.max = max;
        return this;
    }

    public PropertyMD setBounds(double min, double max) {
        if (this.type != Type.FLOAT) {
            throw new IllegalStateException("Floating point bounds can be only set for Floating point property");
        }
        this.minFloat = min;
        this.maxFloat = max;
        return this;
    }

    public PropertyMD setPositive() {
        if (this.type != Type.FLOAT && this.type != Type.INT && this.type != Type.LONG) {
            throw new IllegalStateException("Floating point bounds can be only set for number properties");
        }
        this.min = 1L;
        this.minFloat = 0.001;
        return this;
    }

    public PropertyMD setNonNegative() {
        if (this.type != Type.FLOAT && this.type != Type.INT && this.type != Type.LONG) {
            throw new IllegalStateException("Floating point bounds can be only set for Floating point property");
        }
        this.min = 0L;
        this.minFloat = 0.0;
        return this;
    }

    public PropertyMD setMin(long min) {
        if (this.type != Type.INT && this.type != Type.LONG) {
            throw new IllegalStateException("Integer bounds can be only set for int or long property");
        }
        this.min = min;
        return this;
    }

    public PropertyMD setMax(long max) {
        if (this.type != Type.INT && this.type != Type.LONG) {
            throw new IllegalStateException("Integer bounds can be only set for int or long property");
        }
        this.max = max;
        return this;
    }

    public PropertyMD setMin(double min) {
        if (this.type != Type.FLOAT) {
            throw new IllegalStateException("Floating point bounds can be only set for Floating point property");
        }
        this.minFloat = min;
        return this;
    }

    public PropertyMD setMax(double max) {
        if (this.type != Type.FLOAT) {
            throw new IllegalStateException("Floating point bounds can be only set for Floating point property");
        }
        this.maxFloat = max;
        return this;
    }

    public PropertyMD setLong() {
        this.checkDefault(Type.LONG, this.defaultValue);
        this.type = Type.LONG;
        this.max = Long.MAX_VALUE;
        this.min = Long.MIN_VALUE;
        return this;
    }

    public <T extends Enum<T>> PropertyMD setEnum(T defaultValue) {
        this.enumTypeInstance = defaultValue;
        this.type = Type.ENUM;
        return this;
    }

    public PropertyMD setClass(Class<?> baseClass) {
        this.type = Type.CLASS;
        this.baseClass = baseClass;
        this.checkDefault(Type.CLASS, this.defaultValue);
        return this;
    }

    public PropertyMD setInt() {
        this.checkDefault(Type.INT, this.defaultValue);
        this.type = Type.INT;
        this.max = Integer.MAX_VALUE;
        this.min = Integer.MIN_VALUE;
        return this;
    }

    public PropertyMD setFloat() {
        this.checkDefault(Type.FLOAT, this.defaultValue);
        this.type = Type.FLOAT;
        this.minFloat = Double.MIN_VALUE;
        this.maxFloat = Double.MAX_VALUE;
        return this;
    }

    public PropertyMD setBoolean() {
        this.checkDefault(Type.BOOLEAN, this.defaultValue);
        this.type = Type.BOOLEAN;
        return this;
    }

    public PropertyMD setPath() {
        this.type = Type.PATH;
        return this;
    }

    public PropertyMD setList(boolean numericalKeys) {
        this.type = Type.LIST;
        this.numericalListKeys = numericalKeys;
        return this;
    }

    public boolean numericalListKeys() {
        return this.numericalListKeys;
    }

    public boolean canHaveSubkeys() {
        return this.canHaveSubkeys;
    }

    public PropertyMD setCanHaveSubkeys() {
        this.canHaveSubkeys = true;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public double getMinFloat() {
        return this.minFloat;
    }

    public double getMaxFloat() {
        return this.maxFloat;
    }

    public Type getType() {
        return this.type;
    }

    public Enum<?> getEnumTypeInstance() {
        return this.enumTypeInstance;
    }

    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    protected boolean isBoolean(String val) {
        if (val == null) {
            return false;
        }
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("yes")) {
            return true;
        }
        return val.equalsIgnoreCase("false") || val.equalsIgnoreCase("no");
    }

    protected boolean isLong(String val) {
        try {
            Long.parseLong(val);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isInt(String val) {
        try {
            Integer.parseInt(val);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isFloat(String val) {
        block3: {
            try {
                if (val != null) break block3;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        Double.parseDouble(val);
        return true;
    }

    protected boolean isClass(String val) {
        block3: {
            try {
                if (val != null) break block3;
                return false;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        Class<?> cls = Class.forName(val);
        return this.baseClass == null || this.baseClass.isAssignableFrom(cls);
    }

    public String getTypeDescription() {
        switch (this.type) {
            case STRING: {
                return "string";
            }
            case BOOLEAN: {
                return "[true, false]";
            }
            case ENUM: {
                Object[] allValues = this.enumTypeInstance.getDeclaringClass().getEnumConstants();
                return Arrays.toString(allValues);
            }
            case INT: 
            case LONG: {
                boolean hasMin = false;
                if (this.min != Integer.MIN_VALUE && this.min != Long.MIN_VALUE) {
                    hasMin = true;
                }
                boolean hasMax = false;
                if (this.max != Integer.MAX_VALUE && this.max != Long.MAX_VALUE) {
                    hasMax = true;
                }
                if (!hasMin && !hasMax) {
                    return "integer number";
                }
                if (hasMin && hasMax) {
                    return "integer [" + this.min + " -- " + this.max + "]";
                }
                if (hasMin) {
                    return "integer >= " + this.min;
                }
                if (hasMax) {
                    return "integer <= " + this.max;
                }
            }
            case PATH: {
                return "filesystem path";
            }
            case LIST: {
                return "list of properties with a common prefix";
            }
            case FLOAT: {
                boolean hasMinF = false;
                if (this.minFloat != Double.MIN_VALUE && this.minFloat != Double.MIN_VALUE) {
                    hasMinF = true;
                }
                boolean hasMaxF = false;
                if (this.maxFloat != Double.MAX_VALUE && this.maxFloat != Double.MAX_VALUE) {
                    hasMaxF = true;
                }
                if (!hasMinF && !hasMaxF) {
                    return "floating point number";
                }
                if (hasMinF && hasMaxF) {
                    return "floating [" + this.minFloat + " -- " + this.maxFloat + "]";
                }
                if (hasMinF) {
                    return "floating > " + this.minFloat;
                }
                if (hasMaxF) {
                    return "floating < " + this.maxFloat;
                }
            }
            case CLASS: {
                return "Class extending " + this.baseClass.getName();
            }
        }
        return "UNKNOWN";
    }

    public DocumentationCategory getCategory() {
        return this.category;
    }

    public PropertyMD setCategory(DocumentationCategory category) {
        this.category = category;
        return this;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public PropertyMD setSortKey(String sortKey) {
        this.sortKey = sortKey;
        return this;
    }

    public PropertyMD clone() {
        try {
            return (PropertyMD)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("BUG: " + e);
        }
    }

    public static class DocumentationCategory
    implements Comparable<DocumentationCategory> {
        private String name;
        private String sortKey = null;

        public DocumentationCategory(String name) {
            this.name = name;
            if (name == null) {
                name = "";
            }
        }

        public DocumentationCategory(String name, String sortKey) {
            this(name);
            this.sortKey = sortKey;
        }

        public String getName() {
            return this.name;
        }

        public String getSortKey() {
            return this.sortKey;
        }

        @Override
        public int compareTo(DocumentationCategory o) {
            String myKey = this.sortKey == null ? this.name : this.sortKey;
            String otherKey = o.getSortKey() == null ? o.getName() : o.getSortKey();
            return myKey.compareTo(otherKey);
        }
    }

    public static enum Type {
        INT,
        LONG,
        FLOAT,
        BOOLEAN,
        STRING,
        PATH,
        ENUM,
        LIST,
        CLASS;

    }
}

