/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class PropertyGroupHelper {
    private final Map properties;
    private final String[] acceptedPatterns;
    private final boolean isRegexp;
    private final Pattern[] patterns;

    public PropertyGroupHelper(Map properties, String ... patterns) {
        this(properties, false, patterns);
    }

    public PropertyGroupHelper(Map properties, boolean isRegexp, String ... patterns) {
        this.properties = properties;
        this.acceptedPatterns = patterns;
        this.isRegexp = isRegexp;
        this.patterns = isRegexp ? this.createPatterns() : null;
    }

    public Iterator<String> keys() {
        final Iterator backing = this.properties.keySet().iterator();
        return new Iterator<String>(){
            private String next = null;

            boolean filter(String key) {
                if (PropertyGroupHelper.this.isRegexp) {
                    return PropertyGroupHelper.this.filterRegexp(key);
                }
                return PropertyGroupHelper.this.filterPlain(key);
            }

            @Override
            public boolean hasNext() {
                return this.getNextMatching() != null;
            }

            private String getNextMatching() {
                if (this.next != null) {
                    return this.next;
                }
                if (!backing.hasNext()) {
                    this.next = null;
                    return null;
                }
                String res = (String)backing.next();
                if (res == null) {
                    this.next = null;
                    return null;
                }
                if (!this.filter(res)) {
                    return this.getNextMatching();
                }
                this.next = res;
                return res;
            }

            @Override
            public String next() {
                String res = this.getNextMatching();
                this.next = null;
                return res;
            }

            @Override
            public void remove() {
                backing.remove();
            }
        };
    }

    private Pattern[] createPatterns() {
        Pattern[] ps = new Pattern[this.acceptedPatterns.length];
        int i = 0;
        while (i < this.acceptedPatterns.length) {
            ps[i] = Pattern.compile(this.acceptedPatterns[i]);
            ++i;
        }
        return ps;
    }

    private boolean filterRegexp(String key) {
        Pattern[] patternArray = this.patterns;
        int n = this.patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            if (p.matcher(key).matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean filterPlain(String key) {
        String[] stringArray = this.acceptedPatterns;
        int n = this.acceptedPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (key.startsWith(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Map<String, String> getFilteredMap() {
        return this.getFilteredMap(null);
    }

    public Map<String, String> getFilteredMap(String containedString) {
        HashMap<String, String> props = new HashMap<String, String>();
        Iterator<String> keys = this.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (containedString == null) {
                props.put(key, String.valueOf(this.properties.get(key)));
                continue;
            }
            if (!key.contains(containedString)) continue;
            props.put(key, String.valueOf(this.properties.get(key)));
        }
        return props;
    }
}

