/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util;

import eu.unicore.util.DefaultLogFactory;
import eu.unicore.util.LoggerFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

public class Log {
    private static LoggerFactory spi;
    public static final String UNICORE = "unicore";
    public static final String ADMIN = "unicore.admin";
    public static final String WSRFLITE = "unicore.wsrflite";
    public static final String PERSISTENCE = "unicore.wsrflite.persistence";
    public static final String SERVICES = "unicore.services";
    public static final String SECURITY = "unicore.security";
    public static final String CLIENT = "unicore.client";
    public static final String CONNECTIONS = "unicore.connections";
    public static final String HTTP_SERVER = "unicore.httpserver";
    public static final String CONFIGURATION = "unicore.configuration";

    static {
        String factName = System.getProperty(LoggerFactory.LOGGER_FACTORY_PROPERTY);
        if (factName != null) {
            try {
                Class<?> factClazz = Class.forName(factName);
                Object factRaw = factClazz.newInstance();
                spi = (LoggerFactory)factRaw;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Can't instantiate logger factory class: " + factName + " using default");
                spi = new DefaultLogFactory();
            }
        } else {
            spi = new DefaultLogFactory();
        }
    }

    protected Log() {
    }

    public static String getLoggerName(String prefix, Class<?> clazz) {
        return spi.getLoggerName(prefix, clazz);
    }

    public static Logger getLogger(String prefix, Class<?> clazz) {
        return spi.getLogger(prefix, clazz);
    }

    public static void logException(String message, Throwable cause) {
        Log.logException(message, cause, Logger.getLogger(WSRFLITE));
    }

    public static void logException(String message, Throwable cause, Logger logger) {
        logger.error(message);
        if (cause != null) {
            logger.error("The root error was: " + Log.getDetailMessage(cause));
            if (logger.isDebugEnabled()) {
                logger.debug("Stack trace", cause);
            } else {
                logger.error("To see the full error stack trace, set log4j.logger." + logger.getName() + "=DEBUG");
            }
        }
    }

    public static String getDetailMessage(Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        Throwable cause = throwable;
        String message = null;
        String type = null;
        type = cause.getClass().getName();
        do {
            type = cause.getClass().getName();
            message = cause.getMessage();
        } while ((cause = cause.getCause()) != null);
        if (message != null) {
            sb.append(type).append(": ").append(message);
        } else {
            sb.append(type).append(" (no further message available)");
        }
        return sb.toString();
    }

    public static String createFaultMessage(String message, Throwable cause) {
        return String.valueOf(message) + ": " + Log.getDetailMessage(cause);
    }

    public static void cleanLogContext() {
        MDC.remove("clientName");
    }
}

