/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.server.FileAccess;
import eu.unicore.uftp.server.unix.UnixUser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class SetUIDFileAccess
implements FileAccess {
    private static final Logger logger;
    final UnixUser uftpdUser = new UnixUser(System.getProperty("user.name"));

    public SetUIDFileAccess() {
        logger.info("Started as " + this.uftpdUser);
    }

    private void reset() {
        UnixUser.setEUid(this.uftpdUser.getUid());
        UnixUser.setEGid(this.uftpdUser.getGid());
        logger.info("Reset to userID=" + this.uftpdUser.getLoginName());
    }

    private void switchTo(UnixUser user) {
        long start = System.currentTimeMillis();
        if (user.getUid() == 0) {
            throw new IllegalArgumentException("Attempting to access file as root.");
        }
        logger.info("Switching to user=" + user);
        UnixUser.setEGid(user.getGid());
        int err = UnixUser.initGroups(user.getLoginName(), user.getGid());
        if (err != 0) {
            logger.warn("initgroups() call returned: " + err);
        }
        UnixUser.setEUid(user.getUid());
        UnixUser newUser = UnixUser.whoami();
        logger.info("New effective user=" + newUser.getEffective() + " [time for switch: " + (System.currentTimeMillis() - start) + " ms]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InputStream readFile(String canonicalPath, String userID, String groupID, int bufferSize) throws Exception {
        UnixUser user = new UnixUser(userID);
        FileInputStream fis = null;
        try {
            this.switchTo(user);
            fis = new FileInputStream(canonicalPath);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fis, bufferSize);
            return bufferedInputStream;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OutputStream writeFile(String canonicalPath, boolean append, String userID, String groupID, int bufferSize) throws Exception {
        UnixUser user = new UnixUser(userID);
        FileOutputStream fos = null;
        try {
            this.switchTo(user);
            fos = new FileOutputStream(canonicalPath, append);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fos, bufferSize);
            return bufferedOutputStream;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void setUser(String canonicalPath, String user, String group) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RandomAccessFile getRandomAccessFile(File file, String userID, String groupID, String mode) throws Exception {
        UnixUser user = new UnixUser(userID);
        try {
            this.switchTo(user);
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, mode);
            return randomAccessFile;
        }
        finally {
            this.reset();
        }
    }

    static {
        block2: {
            logger = Logger.getLogger(SetUIDFileAccess.class);
            try {
                System.loadLibrary("uftp-unix");
            }
            catch (Error err) {
                if (System.getProperty("uftp-unit-test") != null) break block2;
                throw err;
            }
        }
    }
}

