/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uftp.server;

import eu.unicore.uftp.dpc.AuthorizationCheck;
import eu.unicore.uftp.dpc.AuthorizationFailureException;
import eu.unicore.uftp.dpc.DPCServer;
import eu.unicore.uftp.dpc.ProtocolViolationException;
import eu.unicore.uftp.dpc.Utils;
import eu.unicore.uftp.server.DefaultFileAccess;
import eu.unicore.uftp.server.FileAccess;
import eu.unicore.uftp.server.SetUIDFileAccess;
import eu.unicore.uftp.server.UFTPTransferRequest;
import eu.unicore.uftp.server.UFTPWorker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class ServerThread
extends Thread
implements AuthorizationCheck {
    private static final Logger logger = Logger.getLogger(ServerThread.class);
    private final DPCServer server;
    private final Map<InetAddress, List<UFTPTransferRequest>> jobMap;
    private final Map<InetAddress, AtomicInteger> runningConnectionsMap;
    private volatile boolean isHalt = false;
    private final ScheduledExecutorService executor;
    public static final long MAX_JOB_AGE = 300000L;
    private int maxStreams;
    private int maxControlConnectionsPerClient = 128;
    private int bufferSize = 131072;
    private FileAccess fileAccess;

    public ServerThread(InetAddress ip, int port, int backlog, int maxStreams) throws IOException {
        this.server = new DPCServer(ip, port, backlog, this);
        this.maxStreams = maxStreams;
        this.jobMap = new ConcurrentHashMap<InetAddress, List<UFTPTransferRequest>>();
        this.runningConnectionsMap = new ConcurrentHashMap<InetAddress, AtomicInteger>();
        this.executor = Utils.getExecutor();
        this.setupExpiryCheck();
        this.getFileAccess();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (!this.isHalt) {
                try {
                    final DPCServer.Connection connection = this.server.accept();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            ServerThread.this.processConnection(connection, ServerThread.this.maxStreams);
                        }
                    };
                    this.executor.execute(r);
                }
                catch (SocketTimeoutException ste) {
                }
                catch (IOException e) {
                    if (!(e instanceof SocketException)) continue;
                    throw (SocketException)e;
                    return;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnection(DPCServer.Connection connection, int maxStreams) {
        InetAddress client = connection.getAddress();
        try {
            List<UFTPTransferRequest> jobs = this.jobMap.get(client);
            if (jobs == null || jobs.size() == 0) {
                logger.info("Rejecting connection from " + client + " : no valid job for that client address.");
                connection.close();
                return;
            }
            UFTPTransferRequest job = (UFTPTransferRequest)connection.establish();
            jobs.remove(job);
            if (jobs.size() == 0) {
                Map<InetAddress, List<UFTPTransferRequest>> map = this.jobMap;
                synchronized (map) {
                    this.jobMap.remove(connection.getAddress());
                }
            }
            AtomicInteger counter = null;
            Map<InetAddress, AtomicInteger> map = this.runningConnectionsMap;
            synchronized (map) {
                counter = this.runningConnectionsMap.get(client);
                if (counter == null) {
                    counter = new AtomicInteger();
                }
                this.runningConnectionsMap.put(client, counter);
            }
            counter.incrementAndGet();
            if (jobs != null && counter.get() == this.maxControlConnectionsPerClient) {
                logger.info("Rejecting connection from " + client + " : too many connections for that client .");
                return;
            }
            new UFTPWorker(this, connection, job, maxStreams, this.bufferSize).start();
        }
        catch (ProtocolViolationException e) {
            String msg = "Rejecting connection attempt from " + client + ": protocol violation.";
            logger.info(msg);
        }
        catch (AuthorizationFailureException e) {
            String msg = "Rejecting connection attempt from " + client + ": authorization failed.";
            logger.info(msg);
        }
        catch (Exception ex) {
            String msg = "Error occured";
            logger.info(msg, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UFTPTransferRequest findJob(List<UFTPTransferRequest> jobs, String id) {
        List<UFTPTransferRequest> list = jobs;
        synchronized (list) {
            for (UFTPTransferRequest j : jobs) {
                if (!id.equals(j.getSecret())) continue;
                return j;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(UFTPTransferRequest job) {
        Map<InetAddress, List<UFTPTransferRequest>> map = this.jobMap;
        synchronized (map) {
            List<UFTPTransferRequest> jobs = this.jobMap.get(job.getClient());
            if (jobs == null) {
                jobs = Collections.synchronizedList(new ArrayList());
                this.jobMap.put(job.getClient(), jobs);
            }
            jobs.add(job);
        }
    }

    public void close() throws IOException {
        logger.info("Closing UFTPD server");
        this.halt();
        this.server.close();
        this.executor.shutdownNow();
    }

    public void setTimeout(int time) {
        this.server.setTimeout(time);
    }

    public int getTimeout() {
        return this.server.getTimeout();
    }

    public void setAuthTimeout(int time) {
        this.server.setAuthTimeout(time);
    }

    public int getAuthTimeout() {
        return this.server.getAuthTimeout();
    }

    public int getMaxControlConnectionsPerClient() {
        return this.maxControlConnectionsPerClient;
    }

    public void setMaxControlConnectionsPerClient(int maxControlConnectionsPerClient) {
        this.maxControlConnectionsPerClient = maxControlConnectionsPerClient;
    }

    public void setMaxStreamsPerConnection(int maxStreams) {
        if (maxStreams < 1) {
            throw new IllegalArgumentException("Maximum streams per connection must be >1, got: " + maxStreams);
        }
        this.maxStreams = maxStreams;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size must be >1, got: " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    @Override
    public UFTPTransferRequest isAuthorized(Socket authSocket) {
        List<UFTPTransferRequest> jobs = this.jobMap.get(authSocket.getInetAddress());
        if (jobs == null || jobs.size() == 0) {
            return null;
        }
        try {
            String input = new BufferedReader(new InputStreamReader(authSocket.getInputStream())).readLine();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(authSocket.getOutputStream()));
            UFTPTransferRequest job = this.findJob(jobs, input);
            if ("null".equals(input)) {
                logger.warn("Got 'null' secret, this can potentially lead to user data corruption or loss, please notify user at <" + authSocket.getInetAddress() + "> to update their client!\n");
            }
            if (job != null) {
                bw.write("Authorization OK\n");
                bw.flush();
                return job;
            }
            bw.write("Authorization FAILED: No matching request found.\n");
            bw.flush();
            return null;
        }
        catch (IOException e) {
            logger.warn("IOException: " + e.getMessage() + " when authorising " + authSocket.getInetAddress());
            return null;
        }
    }

    public void notifyConnectionClosed(InetAddress client) {
        AtomicInteger i = this.runningConnectionsMap.get(client);
        if (i != null) {
            i.decrementAndGet();
        }
    }

    public void halt() {
        this.isHalt = true;
    }

    public void setupExpiryCheck() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ServerThread.this.checkForExpiredJobs();
            }
        };
        this.executor.scheduleWithFixedDelay(r, 3000L, 10000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForExpiredJobs() {
        for (Map.Entry<InetAddress, List<UFTPTransferRequest>> entry : this.jobMap.entrySet()) {
            List<UFTPTransferRequest> jobs;
            List<UFTPTransferRequest> list = jobs = entry.getValue();
            synchronized (list) {
                Iterator<UFTPTransferRequest> jobIterator = jobs.iterator();
                while (jobIterator.hasNext()) {
                    UFTPTransferRequest job = jobIterator.next();
                    long age = System.currentTimeMillis() - job.getCreatedTime();
                    if (age <= 300000L) continue;
                    logger.info("Removing expired job from " + job.getUser() + " @ " + job.getClient().getHostAddress());
                    jobIterator.remove();
                }
            }
        }
    }

    public void cleanConnectionCounters() {
        Iterator<Map.Entry<InetAddress, AtomicInteger>> iterator = this.runningConnectionsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<InetAddress, AtomicInteger> entry = iterator.next();
            AtomicInteger counter = entry.getValue();
            if (counter.get() != 0) continue;
            iterator.remove();
        }
    }

    public synchronized FileAccess getFileAccess() {
        if (this.fileAccess == null) {
            try {
                this.fileAccess = new SetUIDFileAccess();
                logger.info("Will switch user IDs");
            }
            catch (UnsatisfiedLinkError ex) {
                logger.warn("Can't load native library for setuid switching, falling back to default mode: " + ex);
            }
            catch (Exception e) {
                logger.warn("Error loading setuid switcher, falling back to default mode: " + e);
            }
            if (this.fileAccess == null) {
                this.fileAccess = new DefaultFileAccess();
                logger.info("NOT switching user IDs, will access all files as user <" + System.getProperty("user.name") + ">");
            }
        }
        return this.fileAccess;
    }
}

